/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Map;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.channel.deploy.DeployGroup;
import org.eclipse.packagedrone.repo.channel.impl.ChannelServiceAccess;
import org.eclipse.packagedrone.repo.channel.impl.ChannelServiceModel;
import org.eclipse.packagedrone.repo.channel.impl.ChannelServiceModify;
import org.eclipse.packagedrone.repo.channel.impl.DeployGroupTypeAdapter;
import org.eclipse.packagedrone.repo.channel.impl.model.ChannelConfiguration;
import org.eclipse.packagedrone.repo.gson.MetaKeyTypeAdapter;
import org.eclipse.packagedrone.storage.apm.AbstractSimpleStorageModelProvider;
import org.eclipse.packagedrone.storage.apm.StorageContext;
import org.eclipse.packagedrone.storage.apm.util.ReplaceOnCloseWriter;

public class ChannelServiceModelProvider
extends AbstractSimpleStorageModelProvider<ChannelServiceAccess, ChannelServiceModify> {
    public ChannelServiceModelProvider() {
        super(ChannelServiceAccess.class, ChannelServiceModify.class);
    }

    protected ChannelServiceAccess makeViewModelTyped(ChannelServiceModify writeModel) {
        return writeModel;
    }

    protected ChannelServiceModify cloneWriteModel(ChannelServiceModify writeModel) {
        return new ChannelServiceModify(writeModel);
    }

    private Path makePath(StorageContext context) {
        return context.getBasePath().resolve("channels.v2.json");
    }

    protected Gson createGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        builder.serializeNulls();
        builder.setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        builder.registerTypeAdapter(DeployGroup.class, (Object)new DeployGroupTypeAdapter());
        builder.registerTypeAdapter(MetaKey.class, (Object)new MetaKeyTypeAdapter());
        return builder.create();
    }

    protected void persistWriteModel(StorageContext context, ChannelServiceModify writeModel) throws Exception {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ReplaceOnCloseWriter writer = new ReplaceOnCloseWriter(this.makePath(context), StandardCharsets.UTF_8);){
            this.createGson().toJson((Object)writeModel.getModel(), (Appendable)writer);
            writer.commit();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected ChannelServiceModify loadWriteModel(StorageContext context) throws Exception {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (BufferedReader reader = Files.newBufferedReader(this.makePath(context), StandardCharsets.UTF_8);){
                ChannelServiceModel model = (ChannelServiceModel)this.createGson().fromJson((Reader)reader, ChannelServiceModel.class);
                return new ChannelServiceModify(model != null ? model : new ChannelServiceModel());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (NoSuchFileException noSuchFileException) {
            return this.tryMigrate(context);
        }
    }

    private ChannelServiceModify tryMigrate(StorageContext context) throws IOException {
        Path v1 = context.getBasePath().resolve("channels.json");
        if (Files.exists(v1, new LinkOption[0])) {
            return this.loadV1(context, v1);
        }
        return new ChannelServiceModify(new ChannelServiceModel());
    }

    private ChannelServiceModify loadV1(StorageContext context, Path v1) throws IOException {
        JsonElement root;
        Throwable throwable = null;
        Object var5_5 = null;
        try (BufferedReader r = Files.newBufferedReader(v1);){
            root = new JsonParser().parse((Reader)r);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        JsonElement nameMap = root.getAsJsonObject().get("nameMap");
        root.getAsJsonObject().add("nameMap", this.transformV1NameMap(nameMap.getAsJsonObject()));
        JsonObject channels = new JsonObject();
        root.getAsJsonObject().add("channels", (JsonElement)channels);
        this.discoverChannels(context, channels);
        ChannelServiceModel model = (ChannelServiceModel)this.createGson().fromJson(root, ChannelServiceModel.class);
        return new ChannelServiceModify(model != null ? model : new ChannelServiceModel());
    }

    private void discoverChannels(StorageContext context, JsonObject channels) throws IOException {
        Path channelsBase = context.getBasePath().resolve("channels");
        if (!Files.isDirectory(channelsBase, new LinkOption[0])) {
            return;
        }
        Files.list(channelsBase).filter(dir -> {
            if (!Files.isDirectory(dir, new LinkOption[0])) {
                return false;
            }
            return Files.exists(dir.resolve("state.json"), new LinkOption[0]);
        }).forEach(dir -> {
            try {
                this.addApmChannel(channels, (Path)dir);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void addApmChannel(JsonObject channels, Path dir) throws IOException {
        JsonObject root;
        String id = "apm_" + dir.getFileName().toString();
        Throwable throwable = null;
        Object var6_6 = null;
        try (BufferedReader r = Files.newBufferedReader(dir.resolve("state.json"));){
            root = (JsonObject)new JsonParser().parse((Reader)r);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        String description = null;
        if (root.has("description") && root.get("description").isJsonPrimitive()) {
            description = root.get("description").getAsString();
        }
        ChannelConfiguration cfg = new ChannelConfiguration();
        cfg.setProviderId("apm");
        cfg.setDescription(description);
        cfg.getConfiguration().put(new MetaKey("apm", "dir-override"), dir.getFileName().toString());
        channels.add(id, this.createGson().toJsonTree((Object)cfg));
    }

    private JsonElement transformV1NameMap(JsonObject nameMap) {
        JsonObject result = new JsonObject();
        for (Map.Entry entry : nameMap.entrySet()) {
            String key = (String)entry.getKey();
            JsonArray arr = new JsonArray();
            arr.add((JsonElement)entry.getValue());
            result.add(key, (JsonElement)arr);
        }
        return result;
    }
}

