/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.rpm;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.packagedrone.utils.rpm.RpmBaseTag;

public enum RpmTag implements RpmBaseTag
{
    NAME(1000),
    VERSION(1001),
    RELEASE(1002),
    EPOCH(1003),
    SUMMARY(1004),
    DESCRIPTION(1005),
    BUILDTIME(1006),
    BUILDHOST(1007),
    INSTALLED_SIZE(1009),
    DISTRIBUTION(1010),
    VENDOR(1011),
    LICENSE(1014),
    PACKAGER(1015),
    GROUP(1016),
    URL(1020),
    OS(1021),
    ARCH(1022),
    SOURCE_PACKAGE(1044),
    ARCHIVE_SIZE(1046),
    PROVIDE_NAME(1047),
    REQUIRE_FLAGS(1048),
    REQUIRE_NAME(1049),
    REQUIRE_VERSION(1050),
    CONFLICT_FLAGS(1053),
    CONFLICT_NAME(1054),
    CONFLICT_VERSION(1055),
    CHANGELOG_TIMESTAMP(1080),
    CHANGELOG_AUTHOR(1081),
    CHANGELOG_TEXT(1082),
    OBSOLETE_NAME(1090),
    PROVIDE_FLAGS(1112),
    PROVIDE_VERSION(1113),
    OBSOLETE_FLAGS(1114),
    OBSOLETE_VERSION(1115),
    BASENAMES(1117),
    DIRNAMES(1118),
    PAYLOAD_FORMAT(1124),
    PAYLOAD_CODING(1125);

    private Integer value;
    private static final Map<Integer, RpmTag> all;

    static {
        all = new HashMap<Integer, RpmTag>(RpmTag.values().length);
        RpmTag[] rpmTagArray = RpmTag.values();
        int n = rpmTagArray.length;
        int n2 = 0;
        while (n2 < n) {
            RpmTag tag = rpmTagArray[n2];
            all.put(tag.getValue(), tag);
            ++n2;
        }
    }

    private RpmTag(Integer value) {
        this.value = value;
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public static RpmTag find(Integer value) {
        return all.get(value);
    }
}

