/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.utils.osgi.bundle;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.packagedrone.repo.utils.osgi.ParserHelper;
import org.eclipse.packagedrone.repo.utils.osgi.bundle.BundleInformation;
import org.eclipse.packagedrone.utils.AttributedValue;
import org.eclipse.packagedrone.utils.Headers;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public class BundleInformationParser {
    private final ZipFile file;
    private final Manifest manifest;

    public BundleInformationParser(ZipFile file) {
        this.file = file;
        this.manifest = null;
    }

    public BundleInformationParser(ZipFile file, Manifest manifest) {
        this.file = file;
        this.manifest = manifest;
    }

    public BundleInformation parse() throws IOException {
        BundleInformation result = new BundleInformation();
        Manifest m = null;
        if (this.manifest != null) {
            m = this.manifest;
        } else if (this.file != null) {
            m = BundleInformationParser.getManifest(this.file);
        }
        if (m == null) {
            return null;
        }
        Attributes ma = m.getMainAttributes();
        AttributedValue id = Headers.parse((String)ma.getValue("Bundle-SymbolicName"));
        AttributedValue version = Headers.parse((String)ma.getValue("Bundle-Version"));
        if (id == null || version == null) {
            return null;
        }
        result.setId(id.getValue());
        result.setSingleton(Boolean.parseBoolean((String)id.getAttributes().get("singleton")));
        result.setVersion(new Version(version.getValue()));
        result.setName(ma.getValue("Bundle-Name"));
        result.setVendor(ma.getValue("Bundle-Vendor"));
        result.setDocUrl(ma.getValue("Bundle-DocURL"));
        result.setLicense(this.makeLicense(ma.getValue("Bundle-License")));
        result.setDescription(ma.getValue("Bundle-Description"));
        result.setEclipseBundleShape(ma.getValue("Eclipse-BundleShape"));
        result.setRequiredExecutionEnvironments(Headers.parseStringList((String)ma.getValue("Bundle-RequiredExecutionEnvironment")));
        this.processImportPackage(result, ma);
        this.processExportPackage(result, ma);
        this.processImportBundle(result, ma);
        this.attachLocalization(result, ma);
        return result;
    }

    private String makeLicense(String value) {
        AttributedValue license = Headers.parse((String)value);
        if (license == null) {
            return null;
        }
        return license.getValue();
    }

    private void processImportBundle(BundleInformation result, Attributes ma) {
        for (AttributedValue av : this.emptyNull(Headers.parseList((String)ma.getValue("Require-Bundle")))) {
            String name = av.getValue();
            String vs = (String)av.getAttributes().get("bundle-version");
            VersionRange vr = null;
            if (vs != null) {
                vr = new VersionRange(vs);
            }
            boolean optional = "optional".equals(av.getAttributes().get("resolution"));
            boolean reexport = "reexport".equals(av.getAttributes().get("visibility"));
            result.getBundleRequirements().add(new BundleInformation.BundleRequirement(name, vr, optional, reexport));
        }
    }

    private void processImportPackage(BundleInformation result, Attributes ma) {
        for (AttributedValue av : this.emptyNull(Headers.parseList((String)ma.getValue("Import-Package")))) {
            String name = av.getValue();
            String vs = (String)av.getAttributes().get("version");
            VersionRange vr = null;
            if (vs != null) {
                vr = new VersionRange(vs);
            }
            boolean optional = "optional".equals(av.getAttributes().get("resolution"));
            result.getPackageImports().add(new BundleInformation.PackageImport(name, vr, optional));
        }
    }

    private void processExportPackage(BundleInformation result, Attributes ma) {
        for (AttributedValue av : this.emptyNull(Headers.parseList((String)ma.getValue("Export-Package")))) {
            String name = av.getValue();
            String vs = (String)av.getAttributes().get("version");
            Version v = null;
            if (vs != null) {
                v = new Version(vs);
            }
            String uses = (String)av.getAttributes().get("uses");
            result.getPackageExports().add(new BundleInformation.PackageExport(name, v, uses));
        }
    }

    private <T> Collection<T> emptyNull(Collection<T> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    private void attachLocalization(BundleInformation result, Attributes ma) throws IOException {
        String loc = ma.getValue("Bundle-Localization");
        if (loc == null) {
            loc = "OSGI-INF/l10n/bundle";
        } else {
            result.setBundleLocalization(loc);
        }
        result.setLocalization(ParserHelper.loadLocalization(this.file, loc));
    }

    public static Manifest getManifest(ZipFile file) throws IOException {
        ZipEntry m = file.getEntry("META-INF/MANIFEST.MF");
        if (m == null) {
            return null;
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream is = file.getInputStream(m);){
            return new Manifest(is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

