/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.web.internal;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.packagedrone.web.ErrorHandler;
import org.eclipse.scada.utils.ExceptionHelper;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorHandlerImpl
implements ErrorHandler {
    private static final Logger logger = LoggerFactory.getLogger(ErrorHandlerImpl.class);
    private final String errorResource;

    public ErrorHandlerImpl() {
        Bundle bundle = FrameworkUtil.getBundle(ErrorHandlerImpl.class);
        this.errorResource = String.format("/bundle/%s/WEB-INF/views/error.jsp", bundle.getBundleId());
    }

    public void handleError(HttpServletRequest request, HttpServletResponse response, Throwable e) throws ServletException, IOException {
        logger.warn("Handling UI error", e);
        response.setStatus(500);
        request.setAttribute("result", (Object)"Operation failed");
        request.setAttribute("message", (Object)ExceptionHelper.getMessage((Throwable)e));
        request.setAttribute("exception", (Object)e);
        request.setAttribute("stacktrace", (Object)ExceptionHelper.formatted((Throwable)e));
        RequestDispatcher rd = request.getRequestDispatcher(this.errorResource);
        if (response.isCommitted()) {
            rd.include((ServletRequest)request, (ServletResponse)response);
        } else {
            rd.forward((ServletRequest)request, (ServletResponse)response);
        }
    }
}

