/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.web.sitemap.servlet;

import java.time.Instant;
import java.util.Optional;
import org.eclipse.packagedrone.repo.web.sitemap.ChangeFrequency;
import org.eclipse.packagedrone.repo.web.sitemap.SitemapExtender;
import org.eclipse.packagedrone.repo.web.sitemap.SitemapGenerator;
import org.eclipse.packagedrone.repo.web.sitemap.SitemapIndexContext;
import org.eclipse.packagedrone.repo.web.sitemap.UrlSetContext;
import org.eclipse.packagedrone.repo.web.sitemap.UrlSetContextCreator;
import org.eclipse.scada.utils.lang.Holder;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

public class MainSitemapGenerator
implements SitemapGenerator {
    private final ServiceTracker<SitemapExtender, SitemapExtender> tracker = new ServiceTracker(FrameworkUtil.getBundle(MainSitemapGenerator.class).getBundleContext(), SitemapExtender.class, null);

    public MainSitemapGenerator() {
        this.tracker.open();
    }

    public void dispose() {
        this.tracker.close();
    }

    public void gatherRoots(SitemapIndexContext context) {
        context.addLocation("main", this.findLastMod());
    }

    public void render(String path, UrlSetContextCreator contextCreator) {
        if (!path.equals("main")) {
            return;
        }
        UrlSetContext context = contextCreator.createUrlSet();
        for (SitemapExtender extender : this.tracker.getTracked().values()) {
            extender.extend(context);
        }
    }

    protected Optional<Instant> findLastMod() {
        final Holder lastMod = new Holder();
        for (SitemapExtender extender : this.tracker.getTracked().values()) {
            extender.extend(new UrlSetContext(){

                public void addLocation(String localUrl, Optional<Instant> lastModification, Optional<ChangeFrequency> changeFrequency, Optional<Double> priority) {
                    if (!lastModification.isPresent()) {
                        return;
                    }
                    if (lastMod.value == null) {
                        lastMod.value = lastModification.get();
                    } else if (lastModification.get().isAfter((Instant)lastMod.value)) {
                        lastMod.value = lastModification.get();
                    }
                }
            });
        }
        return Optional.ofNullable((Instant)lastMod.value);
    }
}

