/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.p2.web;

import com.google.common.net.UrlEscapers;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.annotation.ServletSecurity;
import javax.validation.Valid;
import org.eclipse.packagedrone.repo.MetaKeys;
import org.eclipse.packagedrone.repo.adapter.p2.P2ChannelInformation;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.channel.ModifiableChannel;
import org.eclipse.packagedrone.repo.channel.ReadableChannel;
import org.eclipse.packagedrone.repo.channel.web.breadcrumbs.Breadcrumbs;
import org.eclipse.packagedrone.repo.web.utils.Channels;
import org.eclipse.packagedrone.sec.web.controller.HttpContraintControllerInterceptor;
import org.eclipse.packagedrone.sec.web.controller.Secured;
import org.eclipse.packagedrone.sec.web.controller.SecuredControllerInterceptor;
import org.eclipse.packagedrone.web.Controller;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.RequestMapping;
import org.eclipse.packagedrone.web.RequestMethod;
import org.eclipse.packagedrone.web.ViewResolver;
import org.eclipse.packagedrone.web.controller.ControllerInterceptor;
import org.eclipse.packagedrone.web.controller.ControllerInterceptors;
import org.eclipse.packagedrone.web.controller.binding.BindingResult;
import org.eclipse.packagedrone.web.controller.binding.PathVariable;
import org.eclipse.packagedrone.web.controller.form.FormData;

@Controller
@RequestMapping(value={"/p2.repo"})
@ViewResolver(value="/WEB-INF/views/%s.jsp")
@Secured
@ControllerInterceptors(value={@ControllerInterceptor(value=SecuredControllerInterceptor.class), @ControllerInterceptor(value=HttpContraintControllerInterceptor.class)})
@HttpConstraint(rolesAllowed={"MANAGER"})
public class P2RepoController {
    private ChannelService service;

    public void setService(ChannelService service) {
        this.service = service;
    }

    @RequestMapping(value={"/{channelId}/info"})
    @Secured(value=false)
    @HttpConstraint(value=ServletSecurity.EmptyRoleSemantic.PERMIT)
    public ModelAndView info(@PathVariable(value="channelId") String channelId) throws Exception {
        return Channels.withChannel((ChannelService)this.service, (String)channelId, ReadableChannel.class, channel -> {
            HashMap<String, Object> model = new HashMap<String, Object>();
            Map metaData = channel.getMetaData();
            P2ChannelInformation channelInfo = new P2ChannelInformation();
            MetaKeys.bind((Object)channelInfo, (Map)metaData);
            model.put("channel", channel.getInformation());
            model.put("channelInfo", channelInfo);
            return new ModelAndView("p2info", model);
        });
    }

    @RequestMapping(value={"/{channelId}/edit"}, method={RequestMethod.GET})
    public ModelAndView edit(@PathVariable(value="channelId") String channelId) throws Exception {
        return Channels.withChannel((ChannelService)this.service, (String)channelId, ReadableChannel.class, channel -> {
            HashMap<String, Object> model = new HashMap<String, Object>();
            Map metaData = channel.getContext().getProvidedMetaData();
            P2ChannelInformation channelInfo = new P2ChannelInformation();
            MetaKeys.bind((Object)channelInfo, (Map)metaData);
            model.put("channel", channel.getInformation());
            model.put("command", channelInfo);
            this.fillBreadcrumbs(model, channel.getId().getId(), "Edit");
            return new ModelAndView("p2edit", model);
        });
    }

    private void fillBreadcrumbs(Map<String, Object> model, String channelId, String action) {
        model.put("breadcrumbs", new Breadcrumbs(new Breadcrumbs.Entry[]{new Breadcrumbs.Entry("Home", "/"), new Breadcrumbs.Entry("Channel", Channels.channelTarget((String)channelId)), new Breadcrumbs.Entry(action)}));
    }

    @RequestMapping(value={"/{channelId}/edit"}, method={RequestMethod.POST})
    public ModelAndView editPost(@PathVariable(value="channelId") String channelId, @Valid @FormData(value="command") P2ChannelInformation data, BindingResult result) throws Exception {
        return Channels.withChannel((ChannelService)this.service, (String)channelId, ModifiableChannel.class, channel -> {
            HashMap<String, Object> model = new HashMap<String, Object>();
            if (result.hasErrors()) {
                model.put("channel", channel.getInformation());
                model.put("command", data);
                this.fillBreadcrumbs(model, channelId, "Edit");
                return new ModelAndView("p2edit", model);
            }
            Map providedMetaData = MetaKeys.unbind((Object)data);
            channel.applyMetaData(providedMetaData);
            return new ModelAndView("redirect:/p2.repo/" + UrlEscapers.urlPathSegmentEscaper().escape(channelId) + "/info", model);
        });
    }
}

