/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.rpm.yum.internal;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.packagedrone.VersionInformation;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.channel.CacheEntryInformation;
import org.eclipse.packagedrone.repo.channel.ChannelNotFoundException;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.channel.ReadableChannel;
import org.eclipse.packagedrone.repo.channel.servlet.AbstractChannelServiceServlet;
import org.eclipse.packagedrone.repo.channel.util.DownloadHelper;
import org.eclipse.packagedrone.repo.manage.system.SitePrefixService;
import org.eclipse.packagedrone.repo.web.utils.ChannelCacheHandler;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;

public class YumServlet
extends AbstractChannelServiceServlet {
    private static final long serialVersionUID = 1L;
    private ServiceTracker<SitePrefixService, SitePrefixService> sitePrefixTracker;

    public void init() throws ServletException {
        super.init();
        BundleContext context = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext();
        this.sitePrefixTracker = new ServiceTracker(context, SitePrefixService.class, null);
        this.sitePrefixTracker.open();
    }

    public void destroy() {
        this.sitePrefixTracker.close();
        super.destroy();
    }

    protected SitePrefixService getSitePrefixService() {
        return (SitePrefixService)this.sitePrefixTracker.getService();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String path = request.getPathInfo();
        if (path != null && path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path == null || path.isEmpty()) {
            this.handleWelcome(request, response);
            return;
        }
        String[] segs = path.split("/", 2);
        if (segs.length <= 0) {
            this.handleWelcome(request, response);
            return;
        }
        String channelId = segs[0];
        String remPath = segs.length > 1 ? segs[1] : null;
        try {
            this.getService(request).accessRun(ChannelService.By.nameOrId((String)channelId), ReadableChannel.class, channel -> {
                if (this.handleChannel((ReadableChannel)channel, remPath, request, response)) {
                    return;
                }
                this.handleNotFound(request, response, request.getRequestURI());
            });
        }
        catch (ChannelNotFoundException channelNotFoundException) {
            this.handleMessage(response, 404, String.format("Channel '%s' could not be found", channelId));
        }
    }

    private boolean handleChannel(ReadableChannel channel, String remPath, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (remPath == null || remPath.isEmpty()) {
            if (!request.getPathInfo().endsWith("/")) {
                response.setStatus(301);
                response.sendRedirect(String.valueOf(request.getRequestURI()) + "/");
                return true;
            }
            request.setAttribute("channel", (Object)channel.getInformation());
            this.viewJsp(request, response, "channel.jsp");
            return true;
        }
        if (remPath.equals("config.repo")) {
            this.handleConfig(channel, request, response);
            return true;
        }
        if (remPath.startsWith("pool/")) {
            this.handlePool(channel, remPath, request, response);
            return true;
        }
        if ("repodata".equals(remPath) || "repodata/".equals(remPath)) {
            if (!request.getPathInfo().endsWith("/")) {
                response.setStatus(301);
                response.sendRedirect(String.valueOf(request.getRequestURI()) + "/");
                return true;
            }
            request.setAttribute("channel", (Object)channel.getInformation());
            List files = channel.getCacheEntries().values().stream().filter(ce -> ce.getKey().getNamespace().equals("yum") && ce.getName().startsWith("repodata/")).collect(Collectors.toList());
            files.sort(Comparator.comparing(CacheEntryInformation::getName));
            request.setAttribute("entries", files);
            this.viewJsp(request, response, "repodata.jsp");
            return true;
        }
        if (remPath.startsWith("repodata/")) {
            new ChannelCacheHandler(new MetaKey("yum", remPath)).process(channel, request, response);
            return true;
        }
        return false;
    }

    private void handleConfig(ReadableChannel channel, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setContentType("text/plain");
        Throwable throwable = null;
        Object var5_6 = null;
        try (PrintWriter pw = response.getWriter();){
            pw.append('[').append(channel.getId().getId()).append("]\n");
            String name = this.makeName(channel.getId().getDescription());
            if (name != null) {
                pw.append("name=").append(name).append("\n");
            }
            pw.append("baseurl=").append(this.getSitePrefixService().getSitePrefix()).append("/yum/").append(channel.getId().getId()).append("\n");
            pw.append("enabled=1\n");
            pw.append("gpgcheck=0\n");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String makeName(String description) {
        if (description == null || description.isEmpty()) {
            return null;
        }
        int idx = description.indexOf(10);
        if (idx >= 0) {
            return description.substring(0, idx);
        }
        return description;
    }

    private void handlePool(ReadableChannel channel, String remPath, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String[] segs = remPath.split("/");
        if (segs.length < 3) {
            this.handleNotFound(request, response, request.getRequestURI());
            return;
        }
        Optional artifact = channel.getArtifact(segs[1]);
        if (!artifact.isPresent()) {
            this.handleNotFound(request, response, request.getRequestURI());
            return;
        }
        Optional name = segs.length > 2 ? Optional.ofNullable(segs[segs.length - 1]) : Optional.empty();
        DownloadHelper.streamArtifact((HttpServletResponse)response, (ArtifactInformation)((ArtifactInformation)artifact.get()), Optional.empty(), (boolean)true, (ReadableChannel)channel, art -> name.orElse(art.getName()));
    }

    private void viewJsp(HttpServletRequest request, HttpServletResponse response, String viewName) throws ServletException, IOException {
        request.setAttribute("version", (Object)VersionInformation.VERSION);
        request.getRequestDispatcher("/WEB-INF/views/" + viewName).forward((ServletRequest)request, (ServletResponse)response);
    }

    private void handleNotFound(HttpServletRequest request, HttpServletResponse response, String resource) throws IOException {
        this.handleMessage(response, 404, String.format("Resource '%s' could not be found", resource));
    }

    private void handleMessage(HttpServletResponse response, int status, String message) throws IOException {
        response.setContentType("text/plain");
        response.setStatus(status);
        response.getWriter().write(message);
    }

    private void handleWelcome(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.viewJsp(request, response, "index.jsp");
    }
}

