/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.impl;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.channel.deploy.DeployGroup;
import org.eclipse.packagedrone.repo.channel.deploy.DeployKey;
import org.eclipse.packagedrone.repo.channel.impl.ChannelServiceAccess;
import org.eclipse.packagedrone.repo.channel.impl.ChannelServiceModel;
import org.eclipse.packagedrone.repo.channel.impl.model.ChannelConfiguration;
import org.eclipse.packagedrone.repo.utils.Tokens;
import org.eclipse.packagedrone.utils.Holder;

public class ChannelServiceModify
implements ChannelServiceAccess {
    private final ChannelServiceModel model;
    private final Multimap<String, String> idToNameMap;
    private final Map<String, String> nameToIdMap;
    private final Map<String, DeployGroup> deployGroups;
    private final Map<String, DeployKey> deployKeys;
    private final Map<String, ChannelConfiguration> channels;

    public ChannelServiceModify(ChannelServiceModel model) {
        this.model = new ChannelServiceModel(model);
        this.nameToIdMap = new HashMap<String, String>();
        this.idToNameMap = LinkedHashMultimap.create();
        for (Map.Entry<String, List<String>> entry : model.getNameMap().entrySet()) {
            this.idToNameMap.putAll((Object)entry.getKey(), (Iterable)entry.getValue());
            entry.getValue().stream().forEach(name -> {
                String string = this.nameToIdMap.put((String)name, (String)entry.getKey());
            });
        }
        this.deployGroups = model.getDeployGroups().stream().collect(Collectors.toMap(DeployGroup::getId, i -> i));
        this.deployKeys = model.getDeployGroups().stream().flatMap(group -> group.getKeys().stream()).collect(Collectors.toMap(DeployKey::getId, i -> i));
        this.channels = new HashMap<String, ChannelConfiguration>(model.getChannels().size());
        for (Map.Entry<String, Object> entry : model.getChannels().entrySet()) {
            this.channels.put(entry.getKey(), new ChannelConfiguration((ChannelConfiguration)entry.getValue()));
        }
    }

    public ChannelServiceModify(ChannelServiceModify other) {
        this(other.model);
    }

    @Override
    public String mapToId(String name) {
        return this.nameToIdMap.get(name);
    }

    public void putMapping(String channelId, String name) {
        if (name == null || name.isEmpty()) {
            return;
        }
        this.channelExists(channelId);
        ChannelServiceModify.checkChannelName(name);
        if (this.nameToIdMap.containsKey(name)) {
            throw new IllegalStateException(String.format("There already is a channel with the name '%s'", name));
        }
        this.nameToIdMap.put(name, channelId);
        this.idToNameMap.put((Object)channelId, (Object)name);
        this.model.getNameMap().put(channelId, new ArrayList(this.idToNameMap.get((Object)channelId)));
    }

    private void channelExists(String channelId) {
        if (!this.channels.containsKey(channelId)) {
            throw new IllegalArgumentException(String.format("Channel '%s' does not exists", channelId));
        }
    }

    private static void checkChannelName(String name) {
        if (!ChannelService.NAME_PATTERN.matcher(name).matches()) {
            throw new IllegalArgumentException(String.format("Channel name must match pattern: %s", ChannelService.NAME_PATTERN.pattern()));
        }
    }

    public String deleteMapping(String channelId, String name) {
        if (!this.idToNameMap.containsEntry((Object)channelId, (Object)name)) {
            return null;
        }
        this.nameToIdMap.remove(name);
        this.idToNameMap.remove((Object)channelId, (Object)name);
        Collection names = this.model.getNameMap().get(channelId);
        if (names != null) {
            names.remove(name);
        }
        return channelId;
    }

    public void createChannel(String channelId, ChannelConfiguration cfg) {
        this.channels.put(channelId, cfg);
        this.model.getChannels().put(channelId, cfg);
    }

    public void deleteChannel(String channelId) {
        this.clearChannelNameMappings(channelId);
        this.model.getChannels().remove(channelId);
        this.channels.remove(channelId);
        this.model.getDeployGroupMap().remove(channelId);
    }

    private void clearChannelNameMappings(String channelId) {
        Collection names = this.idToNameMap.removeAll((Object)channelId);
        if (names != null) {
            names.forEach(this.nameToIdMap::remove);
        }
        this.model.getNameMap().remove(channelId);
    }

    ChannelServiceModel getModel() {
        return this.model;
    }

    public DeployGroup createGroup(String name) {
        DeployGroup result = new DeployGroup(UUID.randomUUID().toString(), name, Collections.emptyList());
        this.internalAdd(result);
        return result;
    }

    @Override
    public DeployGroup getDeployGroup(String groupId) {
        return this.deployGroups.get(groupId);
    }

    @Override
    public Map<String, Set<String>> getDeployGroupMap() {
        return Collections.unmodifiableMap(this.model.getDeployGroupMap());
    }

    public void updateGroup(String groupId, String name) {
        this.modifyGroup(groupId, old -> new DeployGroup(old.getId(), name, old.getKeys()));
    }

    private void internalAdd(DeployGroup group) {
        this.model.getDeployGroups().add(group);
        this.deployGroups.put(group.getId(), group);
        group.getKeys().forEach(key -> {
            DeployKey deployKey = this.deployKeys.put(key.getId(), (DeployKey)key);
        });
    }

    private DeployGroup internalRemove(String groupId) {
        DeployGroup result = this.deployGroups.remove(groupId);
        if (result != null) {
            this.model.getDeployGroups().remove(result);
            result.getKeys().stream().map(DeployKey::getId).forEach(this.deployKeys::remove);
        }
        return result;
    }

    public void deleteGroup(String groupId) {
        DeployGroup group = this.internalRemove(groupId);
        if (group != null) {
            boolean cleanup = false;
            for (Set<String> groups : this.model.getDeployGroupMap().values()) {
                if (!groups.remove(groupId)) continue;
                cleanup = true;
            }
            if (cleanup) {
                Iterator<Set<String>> i = this.model.getDeployGroupMap().values().iterator();
                while (i.hasNext()) {
                    if (!i.next().isEmpty()) continue;
                    i.remove();
                }
            }
        }
    }

    @Override
    public List<DeployGroup> getDeployGroups() {
        return Collections.unmodifiableList(this.model.getDeployGroups());
    }

    private void modifyGroup(String groupId, Function<DeployGroup, DeployGroup> func) {
        DeployGroup group = this.internalRemove(groupId);
        if (groupId == null) {
            throw new IllegalArgumentException(String.format("Deploy group '%s' is unknown.", groupId));
        }
        DeployGroup newGroup = func.apply(group);
        if (newGroup != null) {
            this.internalAdd(newGroup);
        }
    }

    public DeployKey createKey(String groupId, String name) {
        Holder result = new Holder();
        this.modifyGroup(groupId, old -> new DeployGroup(old.getId(), old.getName(), old.getKeys(), newGroup -> {
            holder.value = new DeployKey(newGroup, UUID.randomUUID().toString(), name, this.makeKey(), Instant.now());
            return Collections.singletonList((DeployKey)holder.value);
        }));
        return (DeployKey)result.value;
    }

    public DeployKey deleteKey(String keyId) {
        DeployKey key = this.deployKeys.remove(keyId);
        if (key != null) {
            this.deployKeys.remove(key.getId());
            this.modifyGroup(key.getGroup().getId(), old -> new DeployGroup(old.getId(), old.getName(), ChannelServiceModify.subKeys(old.getKeys(), key)));
        }
        return key;
    }

    private static List<DeployKey> subKeys(List<DeployKey> keys, DeployKey key) {
        CopyOnWriteArrayList<DeployKey> result = new CopyOnWriteArrayList<DeployKey>(keys);
        result.remove(key);
        return result;
    }

    @Override
    public DeployKey getDeployKey(String keyId) {
        return this.deployKeys.get(keyId);
    }

    public DeployKey updateKey(String keyId, String name) {
        DeployKey key = this.deployKeys.get(keyId);
        if (key == null) {
            return null;
        }
        Holder result = new Holder();
        this.modifyGroup(key.getGroup().getId(), old -> new DeployGroup(old.getId(), old.getName(), ChannelServiceModify.subKeys(old.getKeys(), key), newGroup -> {
            holder.value = new DeployKey(newGroup, key.getId(), name, key.getKey(), key.getCreationTimestamp());
            return Collections.singleton((DeployKey)holder.value);
        }));
        return (DeployKey)result.value;
    }

    private String makeKey() {
        return Tokens.createToken((int)32);
    }

    public Set<DeployGroup> getDeployGroupsForChannel(String channelId) {
        Set<String> forChannel = this.model.getDeployGroupMap().get(channelId);
        if (forChannel == null) {
            return Collections.emptySet();
        }
        return forChannel.stream().map(this.deployGroups::get).collect(Collectors.toSet());
    }

    public void assignDeployGroup(String channelId, String groupId) {
        if (!this.deployGroups.containsKey(groupId)) {
            throw new IllegalArgumentException(String.format("Deploy group %s does not exists", groupId));
        }
        Set<String> list = this.model.getDeployGroupMap().get(channelId);
        if (list == null) {
            list = new HashSet<String>();
            this.model.getDeployGroupMap().put(channelId, list);
        }
        list.add(groupId);
    }

    public void unassignDeployGroup(String channelId, String groupId) {
        Set<String> list = this.model.getDeployGroupMap().get(channelId);
        if (list == null) {
            return;
        }
        list.remove(groupId);
        if (list.isEmpty()) {
            this.model.getDeployGroupMap().remove(channelId);
        }
    }

    public void setNameMappings(String channelId, Collection<String> names) {
        Objects.requireNonNull(channelId);
        Objects.requireNonNull(names);
        this.clearChannelNameMappings(channelId);
        for (String name : names) {
            this.putMapping(channelId, name);
        }
    }

    @Override
    public Collection<String> getNameMappings(String channelId) {
        return this.idToNameMap.get((Object)channelId);
    }

    public void clearNameMappings() {
        this.model.getNameMap().clear();
        this.idToNameMap.clear();
        this.nameToIdMap.clear();
    }

    @Override
    public Map<String, ChannelConfiguration> getChannels() {
        return Collections.unmodifiableMap(this.channels);
    }

    public void setDescription(String channelId, String description) {
        this.channelExists(channelId);
        ChannelConfiguration entry = this.model.getChannels().get(channelId);
        entry.setDescription(description);
    }

    @Override
    public String getDescription(String channelId) {
        this.channelExists(channelId);
        ChannelConfiguration entry = this.model.getChannels().get(channelId);
        if (entry == null) {
            return null;
        }
        return entry.getDescription();
    }
}

