/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.impl.trigger;

import java.util.function.Consumer;
import org.eclipse.packagedrone.repo.trigger.ConfiguredTrigger;
import org.eclipse.packagedrone.repo.trigger.ConfiguredTriggerFactory;
import org.eclipse.packagedrone.repo.trigger.ConfiguredTriggerFactoryTracker;
import org.eclipse.packagedrone.repo.trigger.ConfiguredTriggerHandler;
import org.eclipse.packagedrone.repo.trigger.TriggerConfiguration;
import org.eclipse.packagedrone.repo.trigger.TriggerDescriptor;
import org.eclipse.scada.utils.ExceptionHelper;

public class ConfiguredTriggerInstance {
    private final Consumer<ConfiguredTriggerFactory> listener = this::setFactory;
    private final String channelId;
    private final ConfiguredTriggerFactoryTracker tracker;
    private TriggerConfiguration configuration;
    private final Consumer<Object> runner;
    private ConfiguredTrigger service;
    private Exception error;
    private ConfiguredTriggerFactory factory;

    public ConfiguredTriggerInstance(String channelId, ConfiguredTriggerFactoryTracker tracker, TriggerConfiguration configuration, Consumer<Object> runner) {
        this.channelId = channelId;
        this.tracker = tracker;
        this.configuration = configuration;
        this.runner = runner;
        tracker.addListener(configuration.getTriggerFactoryId(), this.listener);
    }

    public synchronized void update(String configuration) {
        this.disposeService();
        this.configuration = new TriggerConfiguration(this.configuration.getTriggerFactoryId(), configuration);
        this.tryCreate();
    }

    public void dispose() {
        this.tracker.removeListener(this.configuration.getTriggerFactoryId(), this.listener);
        this.disposeService();
    }

    protected synchronized void setFactory(ConfiguredTriggerFactory factory) {
        this.disposeService();
        this.factory = factory;
        this.tryCreate();
    }

    private void tryCreate() {
        if (this.factory != null) {
            try {
                this.error = null;
                this.service = this.factory.create(this.configuration.getConfiguration());
                this.service.start(this.makeHandler());
            }
            catch (Exception e) {
                this.error = e;
            }
        }
    }

    private ConfiguredTriggerHandler makeHandler() {
        return new ConfiguredTriggerHandler(){

            public String getChannelId() {
                return ConfiguredTriggerInstance.this.channelId;
            }

            public void run(Object context) {
                ConfiguredTriggerInstance.this.runner.accept(context);
            }
        };
    }

    private void disposeService() {
        if (this.service != null) {
            this.service.stop();
            this.service = null;
            this.error = null;
        }
    }

    public TriggerDescriptor getState() {
        final ConfiguredTriggerFactory factory = this.factory;
        final Exception e = this.error;
        if (factory != null && e != null) {
            return new TriggerDescriptor(){

                public String getLabel() {
                    return factory.getLabel();
                }

                public String getDescription() {
                    return factory.getDescription();
                }

                public String getHtmlState() {
                    StringBuilder sb = new StringBuilder();
                    sb.append("<div class=\"alert alert-danger\">");
                    sb.append("<strong>Initialization failure!</strong> ");
                    sb.append("The trigger failed to initialize: ");
                    sb.append("<code>").append(ExceptionHelper.getMessage((Throwable)e)).append("</code>");
                    sb.append("</div>");
                    return sb.toString();
                }

                public Class<?>[] getSupportedContexts() {
                    return new Class[0];
                }
            };
        }
        ConfiguredTrigger service = this.service;
        if (service != null) {
            return service.getState();
        }
        return null;
    }
}

