/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.impl.trigger;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.channel.ChannelId;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.channel.impl.ChannelFeature;
import org.eclipse.packagedrone.repo.channel.impl.ChannelInstanceModel;
import org.eclipse.packagedrone.repo.channel.impl.ChannelInstanceModelAccess;
import org.eclipse.packagedrone.repo.channel.impl.trigger.ConfiguredTriggerContext;
import org.eclipse.packagedrone.repo.channel.impl.trigger.ConfiguredTriggerInstance;
import org.eclipse.packagedrone.repo.channel.impl.trigger.TriggeredChannelImpl;
import org.eclipse.packagedrone.repo.channel.impl.trigger.TriggeredChannelModel;
import org.eclipse.packagedrone.repo.trigger.ConfiguredTriggerFactoryTracker;
import org.eclipse.packagedrone.repo.trigger.ProcessorFactoryTracker;
import org.eclipse.packagedrone.repo.trigger.TriggerConfiguration;
import org.eclipse.packagedrone.repo.trigger.TriggerDescriptor;
import org.eclipse.packagedrone.repo.trigger.TriggerProcessorConfiguration;
import org.eclipse.packagedrone.repo.trigger.TriggerRunner;
import org.eclipse.packagedrone.repo.trigger.TriggeredChannel;
import org.eclipse.packagedrone.storage.apm.StorageManager;
import org.eclipse.packagedrone.utils.Exceptions;

public class TriggeredChannelFeature
implements ChannelFeature,
ConfiguredTriggerContext {
    private final String channelId;
    private final StorageManager storage;
    private final MetaKey storageKey;
    private final ProcessorFactoryTracker processorFactoryTracker;
    private final ConfiguredTriggerFactoryTracker triggerFactory;
    private final Map<String, TriggerDescriptor> predefined;
    private final Map<String, ConfiguredTriggerInstance> configured = new HashMap<String, ConfiguredTriggerInstance>();

    public TriggeredChannelFeature(String channelId, StorageManager storage, MetaKey storageKey, ProcessorFactoryTracker processorFactoryTracker, ConfiguredTriggerFactoryTracker triggerFactory, Map<String, TriggerDescriptor> predefined) {
        this.channelId = channelId;
        this.storage = storage;
        this.storageKey = storageKey;
        this.processorFactoryTracker = processorFactoryTracker;
        this.triggerFactory = triggerFactory;
        this.predefined = predefined;
        TriggeredChannelModel cfg = (TriggeredChannelModel)storage.accessCall(storageKey, ChannelInstanceModelAccess.class, TriggeredChannelImpl::loadConfiguration);
        for (Map.Entry<String, TriggerConfiguration> tc : cfg.getConfiguredTriggers().entrySet()) {
            this.addConfiguredTrigger(tc.getKey(), tc.getValue());
        }
    }

    @Override
    public boolean supportsAccess(Class<?> clazz) {
        return TriggeredChannel.class.equals(clazz);
    }

    @Override
    public <T, R> R access(ChannelId id, Class<T> clazz, ChannelService.ChannelOperation<R, T> operation) throws Exception {
        if (!this.supportsAccess(clazz)) {
            throw new IllegalArgumentException(String.format("Channel feature supports only: %s", TriggeredChannel.class.getName()));
        }
        return (R)this.storage.modifyCall(this.storageKey, ChannelInstanceModel.class, model -> Exceptions.wrapException(() -> {
            TriggeredChannelImpl adapter = this.makeTriggeredChannel(id, (ChannelInstanceModel)model);
            Object result = operation.process((Object)adapter);
            adapter.flush();
            return result;
        }));
    }

    public List<TriggerProcessorConfiguration> getProcessors(String triggerId) {
        return ((TriggeredChannelModel)this.storage.accessCall(this.storageKey, ChannelInstanceModelAccess.class, TriggeredChannelImpl::loadConfiguration)).getProcessors(triggerId);
    }

    private TriggeredChannelImpl makeTriggeredChannel(ChannelId id, ChannelInstanceModel model) {
        return new TriggeredChannelImpl(id, model, this.processorFactoryTracker, this.predefined, this);
    }

    @Override
    public void add(String id, TriggerConfiguration configuration) {
        StorageManager.executeAfterPersist(() -> {
            Map<String, ConfiguredTriggerInstance> map = this.configured;
            synchronized (map) {
                this.addConfiguredTrigger(id, configuration);
            }
        });
    }

    private void addConfiguredTrigger(String id, TriggerConfiguration configuration) {
        Consumer<Object> runner = context -> this.runTrigger(id, context);
        this.configured.put(id, new ConfiguredTriggerInstance(this.channelId, this.triggerFactory, configuration, runner));
    }

    private void runTrigger(String id, Object context) {
        List<TriggerProcessorConfiguration> processors = this.getProcessors(id);
        if (processors != null) {
            new TriggerRunner(this.processorFactoryTracker, processors, context).run();
        }
    }

    @Override
    public void modify(String id, String configuration) {
        StorageManager.executeAfterPersist(() -> {
            Map<String, ConfiguredTriggerInstance> map = this.configured;
            synchronized (map) {
                ConfiguredTriggerInstance instance = this.configured.get(id);
                if (instance != null) {
                    instance.update(configuration);
                }
            }
        });
    }

    @Override
    public void dispose(String id) {
        StorageManager.executeAfterPersist(() -> {
            ConfiguredTriggerInstance instance;
            Map<String, ConfiguredTriggerInstance> map = this.configured;
            synchronized (map) {
                instance = this.configured.remove(id);
            }
            if (instance != null) {
                instance.dispose();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TriggerDescriptor get(String triggerId) {
        Map<String, ConfiguredTriggerInstance> map = this.configured;
        synchronized (map) {
            ConfiguredTriggerInstance instance = this.configured.get(triggerId);
            if (instance != null) {
                return instance.getState();
            }
            return null;
        }
    }
}

