/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.aspect.recipe;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.packagedrone.repo.aspect.PropertiesHelper;
import org.eclipse.packagedrone.repo.aspect.recipe.Recipe;
import org.eclipse.packagedrone.repo.aspect.recipe.RecipeInformation;
import org.eclipse.packagedrone.repo.aspect.recipe.RecipeNotFoundException;
import org.eclipse.packagedrone.utils.osgi.FactoryTracker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class RecipeProcessor
extends FactoryTracker<Recipe, Entry> {
    public RecipeProcessor(BundleContext context) {
        super(context, Recipe.class);
        this.open();
    }

    public void dispose() {
        this.close();
    }

    public List<RecipeInformation> getRecipes() {
        ArrayList<RecipeInformation> result = new ArrayList<RecipeInformation>();
        this.consumeAll(stream -> stream.forEach(entry -> {
            boolean bl = result.add(entry.getInformation());
        }));
        return result;
    }

    public <C extends Comparable<C>> List<RecipeInformation> getSortedRecipes(Function<RecipeInformation, C> func) {
        List<RecipeInformation> result = this.getRecipes();
        Collections.sort(result, new GenericComparator<RecipeInformation, C>(func));
        return result;
    }

    public void process(String id, Consumer<Recipe> recipe) throws RecipeNotFoundException {
        this.consume(id, entry -> recipe.accept(entry.getRecipe()), () -> new RecipeNotFoundException(id));
    }

    protected String getFactoryId(ServiceReference<Recipe> reference) {
        return RecipeProcessor.getString(reference, (String)"service.pid");
    }

    protected Entry mapService(ServiceReference<Recipe> reference, Recipe service) {
        String description;
        String id = RecipeProcessor.getString(reference, (String)"service.pid");
        if (id == null) {
            return null;
        }
        String label = RecipeProcessor.getString(reference, (String)"drone.label");
        if (label == null) {
            label = RecipeProcessor.getString(reference, (String)"service.description");
        }
        if ((description = RecipeProcessor.getString(reference, (String)"drone.description")) == null) {
            description = PropertiesHelper.loadUrl(reference.getBundle(), RecipeProcessor.getString(reference, (String)"drone.description.url"));
        }
        return new Entry(new RecipeInformation(id, label, description), service);
    }

    public static class Entry {
        private final RecipeInformation information;
        private final Recipe recipe;

        public Entry(RecipeInformation information, Recipe recipe) {
            this.information = information;
            this.recipe = recipe;
        }

        public RecipeInformation getInformation() {
            return this.information;
        }

        public Recipe getRecipe() {
            return this.recipe;
        }
    }

    public static class GenericComparator<T, C extends Comparable<C>>
    implements Comparator<T> {
        private final Function<T, C> func;

        public GenericComparator(Function<T, C> func) {
            this.func = func;
        }

        @Override
        public int compare(T o1, T o2) {
            Comparable v2;
            Comparable v1 = (Comparable)this.func.apply(o1);
            if (v1 == (v2 = (Comparable)this.func.apply(o2))) {
                return 0;
            }
            if (v1 == null) {
                return -1;
            }
            return v1.compareTo(v2);
        }
    }
}

