/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.deb.servlet;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.MetaKeys;
import org.eclipse.packagedrone.repo.adapter.deb.ChannelConfiguration;
import org.eclipse.packagedrone.repo.adapter.deb.servlet.CompDirGenerator;
import org.eclipse.packagedrone.repo.adapter.deb.servlet.DistDirGenerator;
import org.eclipse.packagedrone.repo.adapter.deb.servlet.Helper;
import org.eclipse.packagedrone.repo.adapter.deb.servlet.IndexDirGenerator;
import org.eclipse.packagedrone.repo.adapter.deb.servlet.TypeDirGenerator;
import org.eclipse.packagedrone.repo.adapter.deb.servlet.handler.ChannelCacheHandler;
import org.eclipse.packagedrone.repo.adapter.deb.servlet.handler.ContentHandler;
import org.eclipse.packagedrone.repo.adapter.deb.servlet.handler.Handler;
import org.eclipse.packagedrone.repo.adapter.deb.servlet.handler.PoolHandler;
import org.eclipse.packagedrone.repo.adapter.deb.servlet.handler.RedirectHandler;
import org.eclipse.packagedrone.repo.channel.ChannelNotFoundException;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.channel.ReadableChannel;
import org.eclipse.packagedrone.repo.channel.servlet.AbstractChannelServiceServlet;

public class AptServlet
extends AbstractChannelServiceServlet {
    private static final MetaKey KEY_GPG_KEY = new MetaKey("apt", "GPG-KEY");
    private static final long serialVersionUID = 1L;
    private static final Pattern POOL_PATTERN = Pattern.compile("pool/(?<aid>[^/]+)/(?<name>.*)");

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ChannelService service = this.getService(request);
        String path = request.getPathInfo();
        if (path == null) {
            path = "/";
        }
        path = path.replaceAll("^/+", "");
        path = path.replaceAll("/+$", "");
        String[] toks = path.split("/", 2);
        if (path.isEmpty() || toks.length == 0) {
            response.setContentType("text/plain");
            response.getWriter().write("Package Drone - APT repository adapter");
            return;
        }
        String channelId = toks[0];
        try {
            service.accessRun(ChannelService.By.nameOrId((String)channelId), ReadableChannel.class, channel -> {
                String channelPath;
                if (!channel.hasAspect("apt")) {
                    response.setStatus(404);
                    response.getWriter().format("Channel '%s' is not configured as APT repository. Add the \"APT Repository\" channel aspect.", channelId);
                    return;
                }
                ChannelConfiguration cfg = new ChannelConfiguration();
                try {
                    MetaKeys.bind((Object)cfg, (Map)channel.getMetaData());
                }
                catch (Exception exception) {}
                String string2 = channelPath = toks.length > 1 ? toks[1] : null;
                if (channelPath == null || channelPath.isEmpty()) {
                    if (!request.getPathInfo().endsWith("/")) {
                        response.sendRedirect(String.valueOf(request.getRequestURI()) + "/");
                        return;
                    }
                    HashMap<String, Object> model = new HashMap<String, Object>();
                    model.put("dir", new IndexDirGenerator(cfg));
                    Helper.render(response, IndexDirGenerator.class.getResource("content/index.html"), this.makeDefaultTitle((ReadableChannel)channel), model);
                    return;
                }
                if (channelPath.equals("pool")) {
                    new PoolHandler((ReadableChannel)channel, "", "").process(response);
                    return;
                }
                Matcher m = POOL_PATTERN.matcher(channelPath);
                if (m.matches()) {
                    new PoolHandler((ReadableChannel)channel, m.group("aid"), m.group("name")).process(response);
                    return;
                }
                if (cfg == null || !cfg.isValid()) {
                    response.setStatus(503);
                    response.getWriter().format("APT configuration not found or not valid. Please ensure the 'APT Repository' aspect is added to this channel and the configuration is valid.", new Object[0]);
                    return;
                }
                if (channelPath.equals("dists")) {
                    if (!request.getPathInfo().endsWith("/")) {
                        response.sendRedirect(String.valueOf(request.getRequestURI()) + "/");
                        return;
                    }
                    HashMap<String, Object> model = new HashMap<String, Object>();
                    model.put("distribution", cfg.getDistribution());
                    model.put("id", channel.getId());
                    Helper.render(response, Helper.class.getResource("content/dists.html"), this.makeDefaultTitle((ReadableChannel)channel), model);
                    return;
                }
                Handler handler = this.makeHandler(request, (ReadableChannel)channel, channelPath, cfg);
                if (handler == null) {
                    response.setStatus(404);
                    response.getWriter().format("Unable to handle request for '%s'", request.getPathInfo());
                } else {
                    handler.process(response);
                }
            });
        }
        catch (ChannelNotFoundException channelNotFoundException) {
            response.setStatus(404);
            response.getWriter().format("Channel '%s' not found", channelId);
            return;
        }
    }

    protected String makeDefaultTitle(ReadableChannel channel) {
        return String.format("APT Repository | %s", channel.getInformation().makeTitle());
    }

    private Handler makeHandler(HttpServletRequest request, ReadableChannel channel, String channelPath, ChannelConfiguration cfg) {
        block37: {
            String file;
            String[] toks;
            HashMap<String, Object> model;
            block35: {
                String component;
                model = new HashMap<String, Object>();
                model.put("distribution", cfg.getDistribution());
                model.put("id", channel.getId().getId());
                toks = channelPath.split("/");
                if (toks.length == 1 && "GPG-KEY".equals(toks[0])) {
                    return new ChannelCacheHandler(channel, KEY_GPG_KEY);
                }
                if (toks.length == 2 && "dists".equals(toks[0]) && cfg.getDistribution().equals(toks[1])) {
                    if (!request.getPathInfo().endsWith("/")) {
                        return new RedirectHandler(request);
                    }
                    model.put("dir", new DistDirGenerator(cfg));
                    return new ContentHandler(DistDirGenerator.class.getResource("content/dist-index.html"), this.makeDefaultTitle(channel), model);
                }
                if (toks.length != 3 || !"dists".equals(toks[0]) || !cfg.getDistribution().equals(toks[1])) break block35;
                switch (component = toks[2]) {
                    case "InRelease": 
                    case "Release": 
                    case "Release.gpg": {
                        return new ChannelCacheHandler(channel, new MetaKey("apt", String.format("dists/%s/%s", cfg.getDistribution(), component)));
                    }
                }
                if (!cfg.getDefaultComponent().contains(component)) {
                    return null;
                }
                if (!request.getPathInfo().endsWith("/")) {
                    return new RedirectHandler(request);
                }
                model.put("component", component);
                model.put("dir", new CompDirGenerator(cfg));
                return new ContentHandler(CompDirGenerator.class.getResource("content/comp-index.html"), this.makeDefaultTitle(channel), model);
            }
            if (toks.length == 4 && "dists".equals(toks[0]) && cfg.getDistribution().equals(toks[1])) {
                if (!request.getPathInfo().endsWith("/")) {
                    return new RedirectHandler(request);
                }
                String file2 = toks[3];
                if ("source".equals(file2)) {
                    model.put("dir", new TypeDirGenerator(cfg));
                    return new ContentHandler(TypeDirGenerator.class.getResource("content/type-index.html"), this.makeDefaultTitle(channel), model);
                }
                for (String arch : cfg.getArchitectures()) {
                    if (!file2.equals("binary-" + arch)) continue;
                    model.put("dir", new TypeDirGenerator(cfg));
                    return new ContentHandler(TypeDirGenerator.class.getResource("content/type-index.html"), this.makeDefaultTitle(channel), model);
                }
            }
            if (toks.length != 5 || !"dists".equals(toks[0]) || !cfg.getDistribution().equals(toks[1])) break block37;
            String component = toks[2];
            String type = toks[3];
            switch (file = toks[4]) {
                case "Release": 
                case "Packages": {
                    return new ChannelCacheHandler(channel, new MetaKey("apt", String.format("dists/%s/%s/%s/%s", cfg.getDistribution(), component, type, file)));
                }
                case "Packages.gz": {
                    return new ChannelCacheHandler(channel, new MetaKey("apt", String.format("dists/%s/%s/%s/%s", cfg.getDistribution(), component, type, file)));
                }
                case "Packages.bz2": {
                    return new ChannelCacheHandler(channel, new MetaKey("apt", String.format("dists/%s/%s/%s/%s", cfg.getDistribution(), component, type, file)));
                }
            }
        }
        return null;
    }
}

