/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.sec.service.common.internal;

import java.util.Collection;
import org.eclipse.packagedrone.sec.UserInformation;
import org.eclipse.packagedrone.sec.service.LoginException;
import org.eclipse.packagedrone.sec.service.SecurityService;
import org.eclipse.packagedrone.sec.service.UserService;
import org.eclipse.scada.utils.ExceptionHelper;
import org.osgi.framework.FrameworkUtil;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityServiceImpl
implements SecurityService {
    private static final Logger logger = LoggerFactory.getLogger(SecurityServiceImpl.class);
    private final ServiceTracker<UserService, UserService> userServiceTracker = new ServiceTracker(FrameworkUtil.getBundle(SecurityServiceImpl.class).getBundleContext(), UserService.class, null);

    public void activate() {
        this.userServiceTracker.open();
    }

    public void deactivate() {
        this.userServiceTracker.close();
    }

    public UserInformation login(String username, String password) throws LoginException {
        return this.login(username, password, false);
    }

    public UserInformation login(String username, String password, boolean rememberMe) throws LoginException {
        Collection services = this.userServiceTracker.getTracked().values();
        if (services == null || services.isEmpty()) {
            throw new LoginException("No login service available");
        }
        for (UserService service : services) {
            try {
                UserInformation user = service.checkCredentials(username, password, rememberMe);
                if (user == null) continue;
                return user;
            }
            catch (Exception e) {
                if (ExceptionHelper.getRootCause((Throwable)e) instanceof LoginException) {
                    throw e;
                }
                logger.warn("UserService failed", (Throwable)e);
            }
        }
        throw new LoginException("Login error!", "Invalid username or password.");
    }

    public boolean hasUserBase() {
        Collection services = this.userServiceTracker.getTracked().values();
        for (UserService service : services) {
            if (!service.hasUserBase()) continue;
            return true;
        }
        return false;
    }

    public UserInformation refresh(UserInformation user) {
        Collection services = this.userServiceTracker.getTracked().values();
        if (services == null || services.isEmpty()) {
            return user;
        }
        for (UserService service : services) {
            UserInformation refreshedUser = service.refresh(user);
            if (refreshedUser == null) continue;
            return refreshedUser;
        }
        return user;
    }
}

