/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.sec.service.common.internal;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.UUID;
import org.eclipse.packagedrone.repo.utils.Tokens;
import org.eclipse.packagedrone.sec.service.AccessToken;
import org.eclipse.packagedrone.sec.service.common.internal.AccessTokenStorage;

public class ModifiableAccessTokenStorage
implements AccessTokenStorage {
    private final Map<String, AccessToken> tokensById;
    private final Map<String, AccessToken> tokensByToken;
    private final List<AccessToken> tokenList;

    public ModifiableAccessTokenStorage() {
        this((List<AccessToken>)null);
    }

    public ModifiableAccessTokenStorage(List<AccessToken> tokens) {
        if (tokens != null) {
            this.tokensById = new HashMap<String, AccessToken>(tokens.size());
            this.tokensByToken = new HashMap<String, AccessToken>(tokens.size());
            this.tokenList = new ArrayList<AccessToken>(tokens);
            for (AccessToken token : tokens) {
                this.tokensById.put(token.getId(), token);
                this.tokensByToken.put(token.getToken(), token);
            }
        } else {
            this.tokensById = new HashMap<String, AccessToken>();
            this.tokensByToken = new HashMap<String, AccessToken>();
            this.tokenList = new ArrayList<AccessToken>();
        }
    }

    public ModifiableAccessTokenStorage(ModifiableAccessTokenStorage other) {
        this.tokensById = new HashMap<String, AccessToken>(other.tokensById);
        this.tokensByToken = new HashMap<String, AccessToken>(other.tokensByToken);
        this.tokenList = new ArrayList<AccessToken>(other.tokenList);
    }

    public AccessToken createAccessToken(String description) {
        String accessToken = String.valueOf(Tokens.createToken((int)32)) + Long.toHexString(System.currentTimeMillis());
        AccessToken token = new AccessToken(UUID.randomUUID().toString(), accessToken, description, Instant.now());
        this.tokensById.put(token.getId(), token);
        this.tokensByToken.put(token.getToken(), token);
        this.tokenList.add(token);
        Collections.sort(this.tokenList, Comparator.comparing(AccessToken::getId));
        return token;
    }

    public void deleteAccessToken(String id) {
        AccessToken accessToken = this.tokensById.remove(id);
        if (accessToken != null) {
            this.tokensByToken.remove(accessToken.getToken());
            this.tokenList.remove(accessToken);
        }
    }

    @Override
    public Optional<AccessToken> getToken(String id) {
        return Optional.ofNullable(this.tokensById.get(id));
    }

    @Override
    public Optional<AccessToken> getByToken(String accessToken) {
        return Optional.ofNullable(this.tokensByToken.get(accessToken));
    }

    @Override
    public List<AccessToken> list() {
        return Collections.unmodifiableList(this.tokenList);
    }

    public void editAccessToken(String id, String description) {
        AccessToken token = this.tokensById.get(id);
        if (token == null) {
            throw new NoSuchElementException();
        }
        AccessToken newToken = new AccessToken(token.getId(), token.getToken(), description, token.getCreationTimestamp());
        this.tokensById.put(token.getId(), newToken);
        this.tokensByToken.put(token.getToken(), newToken);
        ListIterator<AccessToken> i = this.tokenList.listIterator();
        while (i.hasNext()) {
            if (i.next() != token) continue;
            i.set(newToken);
        }
    }
}

