/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.storage.apm.util;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.function.Function;

public class ReplaceOnCloseOutputStream
extends OutputStream {
    private final OutputStream out;
    private final Path targetName;
    private final Path tmp;
    private boolean commited;
    private boolean closed;

    public ReplaceOnCloseOutputStream(Path path) throws IOException {
        this(path, null);
    }

    public ReplaceOnCloseOutputStream(Path path, Function<OutputStream, OutputStream> streamCustomizer) throws IOException {
        this.targetName = path;
        this.tmp = path.resolveSibling(String.valueOf(path.getName(path.getNameCount() - 1).toString()) + ".swp");
        Files.deleteIfExists(this.tmp);
        this.out = streamCustomizer != null ? streamCustomizer.apply(Files.newOutputStream(this.tmp, new OpenOption[0])) : Files.newOutputStream(this.tmp, new OpenOption[0]);
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    public void commit() {
        this.commited = true;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.out.close();
        }
        catch (Throwable throwable) {
            try {
                if (this.commited) {
                    Files.move(this.tmp, this.targetName, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                }
            }
            finally {
                Files.deleteIfExists(this.tmp);
            }
            throw throwable;
        }
        try {
            if (this.commited) {
                Files.move(this.tmp, this.targetName, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        finally {
            Files.deleteIfExists(this.tmp);
        }
    }
}

