/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.xml;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.function.Consumer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.packagedrone.repo.xml.internal.Activator;
import org.eclipse.packagedrone.utils.xml.XmlToolsFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlHelper {
    private final TransformerFactory transformerFactory;
    private final XPathFactory xpathFactory;
    private final DocumentBuilderFactory dbf;
    private final DocumentBuilderFactory dbfNs;
    private final XmlToolsFactory tools = Activator.getXmlToolsFactory();

    public XmlHelper() {
        this.dbf = this.tools.newDocumentBuilderFactory();
        this.dbfNs = this.tools.newDocumentBuilderFactory();
        this.dbfNs.setNamespaceAware(true);
        this.transformerFactory = this.tools.newTransformerFactory();
        this.xpathFactory = this.tools.newXPathFactory();
    }

    @Deprecated
    public static XPathFactory createXPathFactory() {
        return Activator.getXmlToolsFactory().newXPathFactory();
    }

    public Document create() {
        try {
            return this.dbf.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public Document createNs() {
        try {
            return this.dbfNs.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public DocumentBuilder getBuilder() throws Exception {
        return this.dbf.newDocumentBuilder();
    }

    public Document parse(InputStream stream) throws Exception {
        return this.dbf.newDocumentBuilder().parse(stream);
    }

    public Document parseNs(InputStream stream) throws Exception {
        return this.dbfNs.newDocumentBuilder().parse(stream);
    }

    public String toString(Node doc) {
        try {
            StringWriter sw = new StringWriter();
            this.write(doc, sw);
            sw.close();
            return sw.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void write(Node doc, OutputStream stream) throws Exception {
        this.write(doc, new StreamResult(stream));
    }

    public void write(Node doc, Writer writer) throws Exception {
        this.write(doc, new StreamResult(writer));
    }

    public void write(Node doc, Result result) throws TransformerException {
        Transformer transformer = this.transformerFactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        transformer.transform(source, result);
    }

    public static void write(TransformerFactory transformerFactory, Node node, Result result) throws TransformerException {
        XmlHelper.write(transformerFactory, node, result, null);
    }

    public static void write(TransformerFactory transformerFactory, Node node, Result result, Consumer<Transformer> transformerCustomizer) throws TransformerException {
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(node);
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        if (transformerCustomizer != null) {
            transformerCustomizer.accept(transformer);
        }
        transformer.transform(source, result);
    }

    public byte[] toData(Node doc) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.write(doc, out);
        out.close();
        return out.toByteArray();
    }

    public String getElementValue(Node element, String path) throws Exception {
        return XmlHelper.getElementValue(this.path(element, path));
    }

    public static String getElementValue(Node element, XPathExpression expression) throws Exception {
        return XmlHelper.getElementValue(XmlHelper.executePath(element, expression));
    }

    public static String getElementValue(NodeList list) {
        Iterator<Node> iterator = XmlHelper.iter(list).iterator();
        if (iterator.hasNext()) {
            Node n = iterator.next();
            return XmlHelper.text(n);
        }
        return null;
    }

    private static String text(Node node) {
        return node.getTextContent();
    }

    public static Iterable<Element> iterElement(final Element element, final String name) {
        return new Iterable<Element>(){

            @Override
            public Iterator<Element> iterator() {
                return new ElementIterator(element, name);
            }
        };
    }

    public static Iterable<Node> iter(final NodeList list) {
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return new NodeListIterator(list);
            }
        };
    }

    public NodeList path(Node node, String path) throws XPathExpressionException {
        XPath xpath = this.xpathFactory.newXPath();
        XPathExpression expression = xpath.compile(path);
        return XmlHelper.executePath(node, expression);
    }

    public static NodeList executePath(Node node, XPathExpression expression) throws XPathExpressionException {
        return (NodeList)expression.evaluate(node, XPathConstants.NODESET);
    }

    public static Element addElement(Element parent, String name) {
        Element ele = parent.getOwnerDocument().createElement(name);
        parent.appendChild(ele);
        return ele;
    }

    public static Element addElement(Element parent, String name, Object value) {
        Element ele = XmlHelper.addElement(parent, name);
        if (value != null) {
            ele.setTextContent(value.toString());
        }
        return ele;
    }

    public static Element addOptionalElement(Element parent, String name, Object value) {
        if (value == null) {
            return null;
        }
        Element ele = XmlHelper.addElement(parent, name);
        ele.setTextContent(value.toString());
        return ele;
    }

    public static Element addElementFirst(Element parent, String name) {
        Element ele = parent.getOwnerDocument().createElement(name);
        parent.insertBefore(ele, null);
        return ele;
    }

    public static void fixSize(Element element) {
        int len = element.getChildNodes().getLength();
        if (len > 0) {
            element.setAttribute("size", Integer.toString(len));
        } else {
            element.getParentNode().removeChild(element);
        }
    }

    public static String getText(Element ele, String name) {
        for (Node child : XmlHelper.iter(ele.getChildNodes())) {
            Element childEle;
            if (!(child instanceof Element) || !(childEle = (Element)child).getNodeName().equals(name)) continue;
            return childEle.getTextContent();
        }
        return null;
    }

    public static final class ElementIterator
    implements Iterator<Element> {
        private final Element element;
        private int index;
        private final String name;

        public ElementIterator(Element element) {
            this(element, null);
        }

        public ElementIterator(Element element, String name) {
            this.element = element;
            this.name = name;
        }

        private Element peek() {
            Node node;
            while ((node = this.element.getChildNodes().item(this.index)) != null) {
                if (!(node instanceof Element)) {
                    ++this.index;
                    continue;
                }
                Element ele = (Element)node;
                if (this.name != null && !ele.getNodeName().equals(this.name)) {
                    ++this.index;
                    continue;
                }
                return ele;
            }
            return null;
        }

        @Override
        public Element next() {
            Element ele = this.peek();
            if (ele != null) {
                ++this.index;
            }
            return ele;
        }

        @Override
        public boolean hasNext() {
            return this.peek() != null;
        }
    }

    public static final class NodeListIterator
    implements Iterator<Node> {
        private final NodeList list;
        private int index;

        public NodeListIterator(NodeList list) {
            this.list = list;
        }

        @Override
        public Node next() {
            return this.list.item(this.index++);
        }

        @Override
        public boolean hasNext() {
            return this.index < this.list.getLength();
        }
    }
}

