/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.common.table;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.function.Function;
import org.eclipse.packagedrone.web.common.table.ContentProvider;
import org.eclipse.packagedrone.web.common.table.TableColumn;
import org.eclipse.packagedrone.web.common.table.TableDescriptor;

public interface TableColumnProvider {
    public TableColumn getColumn();

    public void provideContent(TableDescriptor var1, Object var2, PrintWriter var3) throws IOException;

    public static <T> TableColumnProvider stringProvider(TableColumn column, Class<T> clazz, Function<T, String> func) {
        return TableColumnProvider.provider(column, clazz, (item, out) -> {
            String value = (String)func.apply(item);
            if (value != null) {
                out.write(value);
            }
        });
    }

    public static <T> TableColumnProvider provider(final TableColumn column, final Class<T> clazz, final ContentProvider<T> provider) {
        return new TableColumnProvider(){

            @Override
            public TableColumn getColumn() {
                return column;
            }

            @Override
            public void provideContent(TableDescriptor descriptor, Object object, PrintWriter out) throws IOException {
                if (object == null) {
                    return;
                }
                if (clazz.isAssignableFrom(object.getClass())) {
                    Object value = clazz.cast(object);
                    provider.provide(value, out);
                }
            }
        };
    }
}

