/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.controller.validator;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.packagedrone.web.controller.binding.ExceptionError;
import org.eclipse.packagedrone.web.controller.validator.ControllerValidator;
import org.eclipse.packagedrone.web.controller.validator.SimpleValidationContext;
import org.eclipse.packagedrone.web.controller.validator.ValidationResult;
import org.eclipse.packagedrone.web.controller.validator.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerValidatorProcessor
implements Validator {
    private static final Logger logger = LoggerFactory.getLogger(ControllerValidatorProcessor.class);
    private final Object controller;

    public ControllerValidatorProcessor(Object controller) {
        this.controller = controller;
    }

    @Override
    public ValidationResult validate(Object target) {
        if (target == null) {
            return null;
        }
        SimpleValidationContext ctx = new SimpleValidationContext();
        Method[] methodArray = this.controller.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            ControllerValidator cv = m.getAnnotation(ControllerValidator.class);
            if (cv != null && cv.formDataClass() != null && cv.formDataClass().isAssignableFrom(target.getClass())) {
                try {
                    m.invoke(this.controller, target, ctx);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    logger.debug("Failed to validate", (Throwable)e);
                    ctx.error(null, new ExceptionError(e));
                }
            }
            ++n2;
        }
        return ctx.getResult();
    }
}

