/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.tags;

import com.google.gson.stream.JsonWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.packagedrone.utils.Suppressed;
import org.eclipse.packagedrone.utils.io.IOConsumer;

public final class JsonFunctions {
    private JsonFunctions() {
    }

    public static String toJson(Object value) {
        if (value == null) {
            return "[]";
        }
        if (value instanceof Iterable) {
            return JsonFunctions.fromIterator(((Iterable)value).iterator());
        }
        if (value.getClass().isArray()) {
            return JsonFunctions.fromStream(Arrays.stream((Object[])value));
        }
        if (value instanceof Stream) {
            return JsonFunctions.fromStream((Stream)value);
        }
        if (value instanceof Iterator) {
            return JsonFunctions.fromIterator((Iterator)value);
        }
        return JsonFunctions.from(jw -> JsonFunctions.addValue(jw, value));
    }

    private static String fromStream(Stream<?> stream) {
        return JsonFunctions.from(jw -> stream.forEachOrdered(value -> JsonFunctions.addValue(jw, value)));
    }

    private static String fromIterator(Iterator<?> iter) {
        return JsonFunctions.from(jw -> iter.forEachRemaining(value -> JsonFunctions.addValue(jw, value)));
    }

    private static String from(Consumer<JsonWriter> operation) {
        Throwable throwable = null;
        Object var2_3 = null;
        try (JsonBuilder jb = new JsonBuilder();){
            jb.use((IOConsumer<JsonWriter>)((IOConsumer)jw -> {
                jw.beginArray();
                operation.accept((JsonWriter)jw);
                jw.endArray();
            }));
            return jb.toString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void addValue(JsonWriter jw, Object entry) {
        try {
            if (entry != null) {
                jw.value(entry.toString());
            } else {
                jw.nullValue();
            }
        }
        catch (IOException iOException) {}
    }

    private static class JsonBuilder
    implements AutoCloseable {
        private final StringWriter sw = new StringWriter();
        private final JsonWriter jw = new JsonWriter((Writer)this.sw);

        public void use(IOConsumer<JsonWriter> operation) {
            try {
                operation.accept((Object)this.jw);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return this.sw.toString();
        }

        @Override
        public void close() {
            Throwable throwable = null;
            Object var2_3 = null;
            try (Suppressed s = new Suppressed(RuntimeException::new);){
                s.close((Closeable)this.jw);
                s.close((Closeable)this.sw);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }
}

