/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.jaxrs.provider.swagger.internal;

import io.swagger.models.Contact;
import io.swagger.models.Info;
import io.swagger.models.License;
import java.util.Dictionary;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public class SwaggerConfiguration
implements ManagedService {
    public static final String SERVICE_PID = "com.eclipsesource.jaxrs.swagger.config";
    static final String SWAGGER_PREFIX = "swagger.";
    static final String INFO_PREFIX = "swagger.info.";
    static final String PROPERTY_BASE_PATH = "swagger.basePath";
    static final String PROPERTY_HOST = "swagger.host";
    static final String PROPERTY_FILTER_CLASS = "swagger.filterClass";
    static final String PROPERTY_INFO_TITLE = "swagger.info.title";
    static final String PROPERTY_INFO_DESCRIPTION = "swagger.info.description";
    static final String PROPERTY_INFO_VERSION = "swagger.info.version";
    static final String PROPERTY_INFO_TERMS = "swagger.info.termsOfService";
    static final String PROPERTY_INFO_CONTACT_NAME = "swagger.info.contact.name";
    static final String PROPERTY_INFO_CONTACT_URL = "swagger.info.contact.url";
    static final String PROPERTY_INFO_CONTACT_EMAIL = "swagger.info.contact.email";
    static final String PROPERTY_INFO_LICENSE_NAME = "swagger.info.license.name";
    static final String PROPERTY_INFO_LICENSE_URL = "swagger.info.license.url";
    private static final String[] INFO_KEYS = new String[]{"swagger.info.title", "swagger.info.description", "swagger.info.version", "swagger.info.termsOfService", "swagger.info.contact.name", "swagger.info.contact.url", "swagger.info.contact.email", "swagger.info.license.name", "swagger.info.license.url"};
    private Dictionary<String, ?> configuration;

    public void updated(Dictionary<String, ?> configuration) throws ConfigurationException {
        this.configuration = configuration;
    }

    public Info getInfo() {
        if (this.hasInfoValues()) {
            return this.buildInfo();
        }
        return null;
    }

    private boolean hasInfoValues() {
        String[] stringArray = INFO_KEYS;
        int n = INFO_KEYS.length;
        int n2 = 0;
        while (n2 < n) {
            String infoKey = stringArray[n2];
            if (this.hasConfig(infoKey)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private Info buildInfo() {
        Info info = new Info();
        info.setTitle(this.getConfig(PROPERTY_INFO_TITLE));
        info.setDescription(this.getConfig(PROPERTY_INFO_DESCRIPTION));
        info.setVersion(this.getConfig(PROPERTY_INFO_VERSION));
        info.setTermsOfService(this.getConfig(PROPERTY_INFO_TERMS));
        info.setContact(this.buildContact());
        info.setLicense(this.buildLicense());
        return info;
    }

    private Contact buildContact() {
        if (this.hasConfig(PROPERTY_INFO_CONTACT_NAME) || this.hasConfig(PROPERTY_INFO_CONTACT_URL) || this.hasConfig(PROPERTY_INFO_CONTACT_EMAIL)) {
            Contact contact = new Contact();
            contact.setEmail(this.getConfig(PROPERTY_INFO_CONTACT_EMAIL));
            contact.setName(this.getConfig(PROPERTY_INFO_CONTACT_NAME));
            contact.setUrl(this.getConfig(PROPERTY_INFO_CONTACT_URL));
            return contact;
        }
        return null;
    }

    private License buildLicense() {
        if (this.hasConfig(PROPERTY_INFO_LICENSE_NAME) || this.hasConfig(PROPERTY_INFO_LICENSE_URL)) {
            License license = new License();
            license.setName(this.getConfig(PROPERTY_INFO_LICENSE_NAME));
            license.setUrl(this.getConfig(PROPERTY_INFO_LICENSE_URL));
            return license;
        }
        return null;
    }

    public String getBasePath() {
        return this.getConfig(PROPERTY_BASE_PATH);
    }

    public String getHost() {
        return this.getConfig(PROPERTY_HOST);
    }

    public String getFilterClass() {
        return this.getConfig(PROPERTY_FILTER_CLASS);
    }

    private String getConfig(String key) {
        if (this.hasConfig(key)) {
            return (String)this.configuration.get(key);
        }
        return null;
    }

    private boolean hasConfig(String key) {
        if (this.configuration != null) {
            return this.configuration.get(key) != null;
        }
        return false;
    }
}

