/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.manage.system.internal;

import com.google.common.io.CharStreams;
import java.io.FileReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.packagedrone.repo.manage.system.SystemService;

public class SystemServiceImpl
implements SystemService {
    private final String hostname = SystemServiceImpl.discoverHostname();

    public String getHostname() {
        return this.hostname;
    }

    @Override
    public String getDefaultSitePrefix() {
        String prefix = System.getProperty("package.drone.site.prefix");
        if (prefix != null && !prefix.isEmpty()) {
            return prefix;
        }
        prefix = System.getenv("PACKAGE_DRONE_SITE_PREFIX");
        if (prefix != null && !prefix.isEmpty()) {
            return prefix;
        }
        prefix = this.makePrefixFromOsgiProperties();
        if (prefix != null) {
            return prefix;
        }
        return null;
    }

    protected String makePrefixFromOsgiProperties() {
        String port = System.getProperty("org.osgi.service.http.port");
        if (port == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("http://").append(SystemServiceImpl.discoverHostname());
        if (!"80".equals(port)) {
            sb.append(':').append(port);
        }
        return sb.toString();
    }

    private static String discoverHostname() {
        String hostname = System.getenv("HOSTNAME");
        if (hostname == null) {
            hostname = System.getenv("COMPUTERNAME");
        }
        if (hostname == null) {
            try {
                Throwable throwable = null;
                Object var2_3 = null;
                try (FileReader reader = new FileReader("/etc/hostname");){
                    hostname = CharStreams.toString((Readable)reader).trim();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {}
        }
        if (hostname == null) {
            try {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException unknownHostException) {}
        }
        if (hostname == null) {
            hostname = "localhost";
        }
        return hostname;
    }
}

