/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.trigger.cleanup.internal;

import com.google.common.html.HtmlEscapers;
import java.io.PrintWriter;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.channel.ModifiableChannel;
import org.eclipse.packagedrone.repo.cleanup.Cleaner;
import org.eclipse.packagedrone.repo.cleanup.Field;
import org.eclipse.packagedrone.repo.trigger.Processor;
import org.eclipse.packagedrone.repo.trigger.cleanup.CleanupConfiguration;

public class CleanupProcessor
implements Processor {
    private final CleanupConfiguration cfg;

    public CleanupProcessor(CleanupConfiguration cfg) {
        this.cfg = cfg;
    }

    public void process(Object context) {
        ModifiableChannel channel = (ModifiableChannel)context;
        Cleaner cleaner = new Cleaner(() -> ((ModifiableChannel)channel).getArtifacts());
        this.cfg.applyTo(cleaner);
        Cleaner.Result result = cleaner.compute();
        result.deletedSetStream().forEach(id -> {
            boolean bl = channel.getContext().deleteArtifact(id);
        });
    }

    public void streamHtmlState(PrintWriter writer) {
        writer.append("Group all artifacts by: ");
        int i = 0;
        for (MetaKey field : this.cfg.getAggregator().getFields()) {
            if (i > 0) {
                writer.append(", ");
            }
            writer.format("<code>%s</code>", HtmlEscapers.htmlEscaper().escape(field.toString()));
            ++i;
        }
        writer.append(" then sort by the values of: ");
        i = 0;
        for (MetaKey field : this.cfg.getSorter().getFields()) {
            if (i > 0) {
                writer.append(", ");
            }
            writer.format("<code>%s</code> %s", HtmlEscapers.htmlEscaper().escape(field.getKey().toString()), this.makeOrder((Field)field));
            ++i;
        }
        writer.format(" then delete all but the last <strong>%s</strong> entries of each group.", this.cfg.getNumberOfEntries());
        if (this.cfg.isRootOnly()) {
            writer.append(" <strong>Only root</strong> artifacts will be processed.");
        } else {
            writer.append(" <strong>Root and child</strong> artifacts will be processed.");
        }
        if (this.cfg.isIgnoreWhenMissingFields()) {
            writer.append(" Artifacts which are missing an aggregator field will be <strong>ignored</strong>.");
        } else {
            writer.append(" <strong>All artifacts</strong> will be processed. Missing aggregator field values will be replaced by an empty string.");
        }
    }

    private String makeOrder(Field field) {
        switch (field.getOrder()) {
            case ASCENDING: {
                return "<span class=\"glyphicon glyphicon-sort-by-attributes\"></span>";
            }
            case DESCENDING: {
                return "<span class=\"glyphicon glyphicon-sort-by-attributes-alt\"></span>";
            }
        }
        return "";
    }
}

