/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.console;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.scada.utils.str.Tables;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

public class Console {
    private ConfigurationAdmin configAdmin;

    public void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    public void unsetConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = null;
    }

    public void allConfigs() throws Exception {
        this.dump(this.configAdmin.listConfigurations(null));
    }

    public void listConfigs(String filter) throws Exception {
        this.dump(this.configAdmin.listConfigurations(filter));
    }

    public void getConfig(String pid) throws IOException {
        Configuration cfg = this.configAdmin.getConfiguration(pid);
        if (cfg == null) {
            System.out.println("Not found");
            return;
        }
        System.out.format("Location: %s%n", cfg.getBundleLocation());
        System.out.format("Factory PID: %s%n", cfg.getFactoryPid());
        System.out.format("PID: %s%n", cfg.getPid());
        if (cfg.getProperties() != null) {
            LinkedList<List<String>> data = new LinkedList<List<String>>();
            Enumeration en = cfg.getProperties().keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                Object value = cfg.getProperties().get(key);
                data.add(Arrays.asList(key, "" + value));
            }
            Tables.showTable((PrintStream)System.out, Arrays.asList("Key", "Value"), data, (int)2);
        }
    }

    private void dump(Configuration[] cfgs) {
        if (cfgs == null || cfgs.length <= 0) {
            System.out.println("No configurations found!");
            return;
        }
        LinkedList data = new LinkedList();
        Configuration[] configurationArray = cfgs;
        int n = cfgs.length;
        int n2 = 0;
        while (n2 < n) {
            Configuration cfg = configurationArray[n2];
            LinkedList<String> row = new LinkedList<String>();
            row.add(cfg.getFactoryPid());
            row.add(cfg.getPid());
            row.add("" + cfg.getChangeCount());
            row.add(cfg.getBundleLocation());
            data.add(row);
            ++n2;
        }
        Collections.sort(data, new Comparator<List<String>>(){

            @Override
            public int compare(List<String> o1, List<String> o2) {
                int i = 0;
                while (i < Math.min(o1.size(), o2.size())) {
                    int rc;
                    String v2;
                    String v1 = o1.get(i);
                    if (v1 == null) {
                        v1 = "";
                    }
                    if ((v2 = o2.get(i)) == null) {
                        v2 = "";
                    }
                    if ((rc = v1.compareTo(v2)) != 0) {
                        return rc;
                    }
                    ++i;
                }
                return 0;
            }
        });
        Tables.showTable((PrintStream)System.out, Arrays.asList("Factory", "PID", "Changes", "Location"), data, (int)2);
    }
}

