/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.apm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.channel.apm.ArtifactModel;
import org.eclipse.packagedrone.repo.channel.apm.CacheEntryModel;
import org.eclipse.packagedrone.repo.channel.apm.ValidationMessageModel;
import org.eclipse.packagedrone.repo.channel.apm.aspect.AspectMapModel;

public class ChannelModel {
    private String description;
    private boolean locked;
    private Map<MetaKey, String> providedMetaData;
    private Map<MetaKey, String> extractedMetaData;
    private final Map<String, ArtifactModel> artifacts;
    private final Map<MetaKey, CacheEntryModel> cacheEntries;
    private final AspectMapModel aspects;
    private List<ValidationMessageModel> validationMessages;
    private Date creationTimestamp;
    private Date modificationTimestamp;

    public ChannelModel() {
        this.providedMetaData = new HashMap<MetaKey, String>();
        this.artifacts = new HashMap<String, ArtifactModel>();
        this.cacheEntries = new HashMap<MetaKey, CacheEntryModel>();
        this.aspects = new AspectMapModel();
        this.validationMessages = new ArrayList<ValidationMessageModel>();
    }

    public ChannelModel(ChannelModel other) {
        this.creationTimestamp = other.creationTimestamp;
        this.modificationTimestamp = other.modificationTimestamp;
        this.description = other.description;
        this.locked = other.locked;
        this.extractedMetaData = new HashMap<MetaKey, String>(other.extractedMetaData);
        this.providedMetaData = new HashMap<MetaKey, String>(other.providedMetaData);
        this.artifacts = other.artifacts.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new ArtifactModel((ArtifactModel)entry.getValue())));
        this.cacheEntries = other.cacheEntries.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new CacheEntryModel((CacheEntryModel)entry.getValue())));
        this.aspects = new AspectMapModel(other.aspects);
        this.validationMessages = other.validationMessages != null ? new ArrayList<ValidationMessageModel>(other.validationMessages) : new ArrayList();
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setProvidedMetaData(Map<MetaKey, String> providedMetaData) {
        this.providedMetaData = providedMetaData;
    }

    public Map<MetaKey, String> getProvidedMetaData() {
        return this.providedMetaData;
    }

    public void setExtractedMetaData(Map<MetaKey, String> extractedMetaData) {
        this.extractedMetaData = extractedMetaData;
    }

    public Map<MetaKey, String> getExtractedMetaData() {
        return this.extractedMetaData;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void addArtifact(ArtifactInformation ai) {
        this.artifacts.put(ai.getId(), ArtifactModel.fromInformation(ai));
    }

    public void removeArtifact(String artifactId) {
        this.artifacts.remove(artifactId);
    }

    public Map<String, ArtifactModel> getArtifacts() {
        return Collections.unmodifiableMap(this.artifacts);
    }

    public AspectMapModel getAspects() {
        return this.aspects;
    }

    public Map<MetaKey, CacheEntryModel> getCacheEntries() {
        return this.cacheEntries;
    }

    public void setValidationMessages(List<ValidationMessageModel> validationMessages) {
        this.validationMessages = validationMessages;
    }

    public List<ValidationMessageModel> getValidationMessages() {
        return this.validationMessages;
    }

    public void setCreationTimestamp(Date creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    public Date getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public void setModificationTimestamp(Date modificationTimestamp) {
        this.modificationTimestamp = modificationTimestamp;
    }

    public Date getModificationTimestamp() {
        return this.modificationTimestamp;
    }
}

