/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.addon.internal;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import org.eclipse.packagedrone.utils.Suppressed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Watcher
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(Watcher.class);
    private final Path path;
    private final Listener listener;
    private final Thread thread;

    public Watcher(Path path, Listener listener) throws IOException {
        this.path = path;
        this.listener = listener;
        this.thread = new Thread(this::run, "AddonManager/Watcher");
        this.thread.start();
    }

    private void run() {
        while (true) {
            try {
                this.process();
                return;
            }
            catch (IOException e) {
                logger.warn("Watcher failed", (Throwable)e);
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }
        finally {
            logger.warn("Watcher stopped watching: {}", (Object)this.path);
        }
    }

    /*
     * Exception decompiling
     */
    private void process() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void processExisting(Path path) throws IOException {
        Files.list(path).forEachOrdered(file -> this.listener.event((Path)file, Event.ADDED));
    }

    private void handleEvent(WatchEvent<?> event) {
        WatchEvent.Kind<?> kind = event.kind();
        if (kind == StandardWatchEventKinds.OVERFLOW) {
            return;
        }
        Path path = this.path.resolve((Path)event.context());
        if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
            this.listener.event(path, Event.ADDED);
        } else if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
            this.listener.event(path, Event.REMOVED);
        } else if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
            this.listener.event(path, Event.MODIFIED);
        }
    }

    @Override
    public void close() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (Suppressed s = new Suppressed("Failed to dispose addon manager", RuntimeException::new);){
            if (this.thread != null) {
                this.thread.interrupt();
                s.run(this.thread::join);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static enum Event {
        ADDED,
        MODIFIED,
        REMOVED;

    }

    @FunctionalInterface
    public static interface Listener {
        public void event(Path var1, Event var2);
    }
}

