/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.importer.aether;

import com.google.gson.GsonBuilder;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.util.filter.DependencyFilterUtils;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.importer.ImportContext;
import org.eclipse.packagedrone.repo.importer.ImportSubContext;
import org.eclipse.packagedrone.repo.importer.Importer;
import org.eclipse.packagedrone.repo.importer.ImporterDescription;
import org.eclipse.packagedrone.repo.importer.SimpleImporterDescription;
import org.eclipse.packagedrone.repo.importer.aether.ImportConfiguration;
import org.eclipse.packagedrone.repo.importer.aether.MavenCoordinates;
import org.eclipse.packagedrone.repo.importer.aether.RepositoryContext;
import org.eclipse.packagedrone.repo.importer.aether.web.AetherResult;
import org.eclipse.packagedrone.web.LinkTarget;
import org.eclipse.scada.utils.io.RecursiveDeleteVisitor;

public class AetherImporter
implements Importer {
    public static final String ID = "aether";
    private static final SimpleImporterDescription DESCRIPTION = new SimpleImporterDescription();
    private final GsonBuilder gsonBuilder = new GsonBuilder();

    static {
        DESCRIPTION.setId(ID);
        DESCRIPTION.setLabel("Maven 2 Importer");
        DESCRIPTION.setDescription("Import artifacts from Maven Repositories using Eclipse Aether");
        DESCRIPTION.setStartTarget(new LinkTarget("/import/{token}/aether/start"));
    }

    public ImporterDescription getDescription() {
        return DESCRIPTION;
    }

    public void runImport(ImportContext context, String configuration) throws Exception {
        ImportConfiguration cfg = (ImportConfiguration)this.gsonBuilder.create().fromJson(configuration, ImportConfiguration.class);
        this.runImport(context, cfg);
    }

    private void runImport(ImportContext context, ImportConfiguration cfg) throws Exception {
        Path tmpDir = Files.createTempDirectory(ID, new FileAttribute[0]);
        context.addCleanupTask(() -> {
            Files.walkFileTree(tmpDir, (FileVisitor<? super Path>)new RecursiveDeleteVisitor());
            Files.deleteIfExists(tmpDir);
        });
        Collection<ArtifactResult> results = AetherImporter.processImport(tmpDir, cfg);
        LinkedList<ArtifactResult> later = new LinkedList<ArtifactResult>();
        HashMap<String, ImportSubContext> roots = new HashMap<String, ImportSubContext>();
        for (ArtifactResult result : results) {
            if (!result.isResolved()) continue;
            this.importArtifact(context, result, roots, later);
        }
        for (ArtifactResult result : later) {
            this.importArtifact(context, result, roots, null);
        }
    }

    private void importArtifact(ImportContext context, ArtifactResult result, Map<String, ImportSubContext> roots, List<ArtifactResult> later) {
        Artifact artifact = result.getArtifact();
        Map<MetaKey, String> metadata = AetherImporter.makeMetaData(artifact);
        String key = this.makeRootKey(artifact);
        if (later != null && key != null && artifact.getClassifier() != null && !artifact.getClassifier().isEmpty()) {
            ImportSubContext sub = roots.get(key);
            if (sub == null) {
                later.add(result);
            } else {
                sub.scheduleImport(artifact.getFile().toPath(), false, artifact.getFile().getName(), metadata);
            }
        } else {
            ImportSubContext sub = context.scheduleImport(artifact.getFile().toPath(), false, artifact.getFile().getName(), metadata);
            if (key != null) {
                roots.put(key, sub);
            }
        }
    }

    private String makeRootKey(Artifact artifact) {
        if (!"jar".equals(artifact.getExtension())) {
            return null;
        }
        return String.format("%s:%s:%s", artifact.getGroupId(), artifact.getArtifactId(), artifact.getBaseVersion());
    }

    private static Map<MetaKey, String> makeMetaData(Artifact artifact) {
        HashMap<MetaKey, String> md = new HashMap<MetaKey, String>();
        md.put(new MetaKey("mvn", "groupId"), artifact.getGroupId());
        md.put(new MetaKey("mvn", "artifactId"), artifact.getArtifactId());
        md.put(new MetaKey("mvn", "version"), artifact.getVersion());
        md.put(new MetaKey("mvn", "extension"), artifact.getExtension());
        if (artifact.getClassifier() != null) {
            md.put(new MetaKey("mvn", "classifier"), artifact.getClassifier());
        }
        return md;
    }

    public static AetherResult prepareDependencies(Path tmpDir, ImportConfiguration cfg) throws RepositoryException {
        Objects.requireNonNull(tmpDir);
        Objects.requireNonNull(cfg);
        RepositoryContext ctx = new RepositoryContext(tmpDir, cfg.getRepositoryUrl(), cfg.isAllOptional());
        CollectRequest cr = new CollectRequest();
        cr.setRepositories(ctx.getRepositories());
        for (MavenCoordinates coords : cfg.getCoordinates()) {
            Dependency dep = new Dependency((Artifact)new DefaultArtifact(coords.toString()), "compile");
            cr.addDependency(dep);
        }
        DependencyFilter filter = DependencyFilterUtils.classpathFilter((String[])new String[]{"compile"});
        DependencyRequest deps = new DependencyRequest(cr, filter);
        DependencyResult dr = ctx.getSystem().resolveDependencies(ctx.getSession(), deps);
        List arts = dr.getArtifactResults();
        if (!cfg.isIncludeSources()) {
            return AetherImporter.asResult(arts, cfg, Optional.of(dr));
        }
        List<ArtifactRequest> requests = AetherImporter.extendRequests(arts.stream().map(ArtifactResult::getRequest), ctx, cfg);
        return AetherImporter.asResult(AetherImporter.resolve(ctx, requests), cfg, Optional.of(dr));
    }

    public static AetherResult preparePlain(Path tmpDir, ImportConfiguration cfg) throws ArtifactResolutionException {
        Objects.requireNonNull(tmpDir);
        Objects.requireNonNull(cfg);
        RepositoryContext ctx = new RepositoryContext(tmpDir, cfg.getRepositoryUrl(), cfg.isAllOptional());
        List<ArtifactRequest> requests = AetherImporter.extendRequests(cfg.getCoordinates().stream().map(c -> {
            DefaultArtifact artifact = new DefaultArtifact(c.toString());
            return AetherImporter.makeRequest(ctx.getRepositories(), (Artifact)artifact);
        }), ctx, cfg);
        return AetherImporter.asResult(AetherImporter.resolve(ctx, requests), cfg, Optional.empty());
    }

    private static List<ArtifactRequest> extendRequests(Stream<ArtifactRequest> requests, RepositoryContext ctx, ImportConfiguration cfg) {
        LinkedList<ArtifactRequest> result = new LinkedList<ArtifactRequest>();
        Iterator i = requests.iterator();
        while (i.hasNext()) {
            DefaultArtifact pom;
            DefaultArtifact javadoc;
            DefaultArtifact sources;
            ArtifactRequest ar = (ArtifactRequest)i.next();
            result.add(ar);
            if (cfg.isIncludeSources() && (sources = AetherImporter.makeOtherClassifier(ar.getArtifact(), "sources")) != null) {
                result.add(AetherImporter.makeRequest(ctx.getRepositories(), (Artifact)sources));
            }
            if (cfg.isIncludeJavadoc() && (javadoc = AetherImporter.makeOtherClassifier(ar.getArtifact(), "javadoc")) != null) {
                result.add(AetherImporter.makeRequest(ctx.getRepositories(), (Artifact)javadoc));
            }
            if (!cfg.isIncludePoms() || (pom = AetherImporter.makeOtherExtension(ar.getArtifact(), "pom")) == null) continue;
            result.add(AetherImporter.makeRequest(ctx.getRepositories(), (Artifact)pom));
        }
        return result;
    }

    protected static List<ArtifactResult> resolve(RepositoryContext ctx, List<ArtifactRequest> requests) {
        try {
            return ctx.getSystem().resolveArtifacts(ctx.getSession(), requests);
        }
        catch (ArtifactResolutionException e) {
            return e.getResults();
        }
    }

    public static Collection<ArtifactResult> processImport(Path tmpDir, ImportConfiguration cfg) throws ArtifactResolutionException {
        Objects.requireNonNull(tmpDir);
        Objects.requireNonNull(cfg);
        RepositoryContext ctx = new RepositoryContext(tmpDir, cfg.getRepositoryUrl());
        LinkedList<ArtifactRequest> requests = new LinkedList<ArtifactRequest>();
        for (MavenCoordinates coords : cfg.getCoordinates()) {
            DefaultArtifact main = new DefaultArtifact(coords.toString());
            requests.add(AetherImporter.makeRequest(ctx.getRepositories(), (Artifact)main));
        }
        return ctx.getSystem().resolveArtifacts(ctx.getSession(), requests);
    }

    public static AetherResult asResult(Collection<ArtifactResult> results, ImportConfiguration cfg, Optional<DependencyResult> dependencyResult) {
        AetherResult result = new AetherResult();
        HashSet<String> requested = new HashSet<String>(cfg.getCoordinates().size());
        for (MavenCoordinates mc : cfg.getCoordinates()) {
            requested.add(mc.toString());
        }
        HashMap<String, Boolean> optionalDeps = new HashMap<String, Boolean>();
        AetherImporter.fillOptionalDependenciesMap(dependencyResult, optionalDeps);
        for (ArtifactResult ar : results) {
            AetherResult.Entry entry = new AetherResult.Entry();
            MavenCoordinates coordinates = MavenCoordinates.fromResult(ar);
            String key = coordinates.toBase().toString();
            entry.setCoordinates(coordinates);
            entry.setResolved(ar.isResolved());
            entry.setRequested(requested.contains(key));
            entry.setOptional(optionalDeps.getOrDefault(key, Boolean.FALSE));
            if (ar.getExceptions() != null && !ar.getExceptions().isEmpty()) {
                StringBuilder sb = new StringBuilder(((Exception)ar.getExceptions().get(0)).getMessage());
                if (ar.getExceptions().size() > 1) {
                    sb.append(" ...");
                }
                entry.setError(sb.toString());
            }
            result.getArtifacts().add(entry);
        }
        Collections.sort(result.getArtifacts(), Comparator.comparing(AetherResult.Entry::getCoordinates));
        result.setRepositoryUrl(cfg.getRepositoryUrl());
        return result;
    }

    private static void fillOptionalDependenciesMap(Optional<DependencyResult> dependencyResult, final Map<String, Boolean> optionalDeps) {
        if (!dependencyResult.isPresent()) {
            return;
        }
        dependencyResult.get().getRoot().accept(new DependencyVisitor(){

            public boolean visitLeave(DependencyNode node) {
                return true;
            }

            public boolean visitEnter(DependencyNode node) {
                Dependency d = node.getDependency();
                if (d == null) {
                    return true;
                }
                String key = MavenCoordinates.fromArtifact(d.getArtifact()).toBase().toString();
                if (d.isOptional()) {
                    if (!optionalDeps.containsKey(key)) {
                        optionalDeps.put(key, Boolean.TRUE);
                    }
                } else {
                    optionalDeps.put(key, Boolean.FALSE);
                }
                return true;
            }
        });
    }

    private static DefaultArtifact makeOtherClassifier(Artifact main, String classifier) {
        if (main.getClassifier() != null && !main.getClassifier().isEmpty()) {
            return null;
        }
        return new DefaultArtifact(main.getGroupId(), main.getArtifactId(), classifier, main.getExtension(), main.getVersion());
    }

    private static DefaultArtifact makeOtherExtension(Artifact main, String extension) {
        if (main.getClassifier() != null && !main.getClassifier().isEmpty()) {
            return null;
        }
        return new DefaultArtifact(main.getGroupId(), main.getArtifactId(), null, extension, main.getVersion());
    }

    private static ArtifactRequest makeRequest(List<RemoteRepository> repositories, Artifact artifact) {
        ArtifactRequest artifactRequest = new ArtifactRequest();
        artifactRequest.setArtifact(artifact);
        artifactRequest.setRepositories(repositories);
        return artifactRequest;
    }
}

