/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.rpm.internal;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import org.eclipse.packagedrone.repo.adapter.rpm.Constants;
import org.eclipse.packagedrone.repo.adapter.rpm.RpmInformationsJson;
import org.eclipse.packagedrone.repo.aspect.extract.Extractor;
import org.eclipse.packagedrone.utils.rpm.RpmBaseTag;
import org.eclipse.packagedrone.utils.rpm.RpmTag;
import org.eclipse.packagedrone.utils.rpm.info.RpmInformation;
import org.eclipse.packagedrone.utils.rpm.info.RpmInformations;
import org.eclipse.packagedrone.utils.rpm.parse.RpmInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpmExtractor
implements Extractor {
    private static final Logger logger = LoggerFactory.getLogger(RpmExtractor.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void extractMetaData(Extractor.Context context, Map<String, String> metadata) {
        Path path = context.getPath();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                RpmInputStream in = new RpmInputStream((InputStream)new BufferedInputStream(Files.newInputStream(path, StandardOpenOption.READ)));
                try {
                    RpmInformation info = RpmInformations.makeInformation((RpmInputStream)in);
                    if (info == null) {
                        return;
                    }
                    metadata.put("artifactLabel", "RPM Package");
                    metadata.put("name", RpmInformations.asString((Object)in.getPayloadHeader().getTag((RpmBaseTag)RpmTag.NAME)));
                    metadata.put("version", RpmInformations.asString((Object)in.getPayloadHeader().getTag((RpmBaseTag)RpmTag.VERSION)));
                    metadata.put("os", RpmInformations.asString((Object)in.getPayloadHeader().getTag((RpmBaseTag)RpmTag.OS)));
                    metadata.put("arch", RpmInformations.asString((Object)in.getPayloadHeader().getTag((RpmBaseTag)RpmTag.ARCH)));
                    metadata.put("release", RpmInformations.asString((Object)in.getPayloadHeader().getTag((RpmBaseTag)RpmTag.RELEASE)));
                    metadata.put(Constants.KEY_INFO.getKey(), RpmInformationsJson.toJson(info));
                    return;
                }
                finally {
                    if (in == null) return;
                    in.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception e) {
            logger.debug("Failed to parse RPM file", (Throwable)e);
        }
    }
}

