/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.dispatcher.internal;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterTracker
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(TrackedFilter.class);
    private final ServiceTracker<Filter, TrackedFilter> tracker;
    private BundleContext context;
    private TrackedFilter[] filters = null;

    public FilterTracker(BundleContext context) {
        this.context = context;
        this.tracker = new ServiceTracker(context, Filter.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<Filter, TrackedFilter>(){

            public TrackedFilter addingService(ServiceReference<Filter> reference) {
                return FilterTracker.this.addFilter(reference);
            }

            public void modifiedService(ServiceReference<Filter> reference, TrackedFilter service) {
            }

            public void removedService(ServiceReference<Filter> reference, TrackedFilter service) {
                service.dispose();
                FilterTracker.this.filters = null;
            }
        });
    }

    protected TrackedFilter addFilter(ServiceReference<Filter> reference) {
        Filter filter = (Filter)this.context.getService(reference);
        this.filters = null;
        return new TrackedFilter(this.context, filter, reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        TrackedFilter[] localFilters;
        FilterTracker filterTracker = this;
        synchronized (filterTracker) {
            if (this.filters == null) {
                this.filters = (TrackedFilter[])this.tracker.getServices((Object[])new TrackedFilter[0]);
            }
            localFilters = this.filters;
        }
        this.doRunFilter(localFilters, 0, request, response, filterChain);
    }

    private void doRunFilter(final TrackedFilter[] localFilters, final int i, ServletRequest request, ServletResponse response, final FilterChain lastFilterChain) throws IOException, ServletException {
        if (i < localFilters.length) {
            localFilters[i].doFilter(request, response, new FilterChain(){

                public void doFilter(ServletRequest chainRequest, ServletResponse chainResponse) throws IOException, ServletException {
                    FilterTracker.this.doRunFilter(localFilters, i + 1, chainRequest, chainResponse, lastFilterChain);
                }
            });
        } else {
            lastFilterChain.doFilter(request, response);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        logger.info("Open tracker");
        this.tracker.open();
    }

    public void destroy() {
        logger.info("Close tracker");
        this.tracker.close();
    }

    public static class TrackedFilter {
        private final Filter filter;
        private final ServiceReference<Filter> reference;
        private final BundleContext context;

        public TrackedFilter(BundleContext context, Filter filter, ServiceReference<Filter> reference) {
            this.filter = filter;
            this.context = context;
            this.reference = reference;
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
            this.filter.doFilter(request, response, filterChain);
        }

        public void dispose() {
            this.context.ungetService(this.reference);
        }
    }
}

