/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.dispatcher.internal;

import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.packagedrone.utils.AttributedValue;
import org.eclipse.packagedrone.utils.Headers;
import org.eclipse.packagedrone.web.dispatcher.internal.ResourceProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagLibTracker
implements ResourceProvider {
    private static final Logger logger = LoggerFactory.getLogger(TagLibTracker.class);
    private final Set<String> systemTlds = new HashSet<String>();
    private final BundleTracker<TagLibInfo> bundleTracker;
    private final BundleTrackerCustomizer<TagLibInfo> customizer = new BundleTrackerCustomizer<TagLibInfo>(){

        public TagLibInfo addingBundle(Bundle bundle, BundleEvent event) {
            return TagLibTracker.this.createTagLibInfo(bundle);
        }

        public void modifiedBundle(Bundle bundle, BundleEvent event, TagLibInfo object) {
        }

        public void removedBundle(Bundle bundle, BundleEvent event, TagLibInfo object) {
        }
    };
    private final String mappedPrefix;

    public TagLibTracker(BundleContext context, String mappedPrefix) {
        this.systemTlds.add("org.apache.taglibs.standard-impl");
        if (mappedPrefix == null) {
            mappedPrefix = "/WEB-INF/";
        }
        this.mappedPrefix = mappedPrefix;
        this.bundleTracker = new BundleTracker(context, 36, this.customizer);
        this.bundleTracker.open();
    }

    @Override
    public void dispose() {
        this.bundleTracker.close();
    }

    protected boolean fillFromExportHeader(Bundle bundle, String headerName, Map<String, URL> tlds) {
        String tldHeader = (String)bundle.getHeaders().get(headerName);
        if (tldHeader == null) {
            return false;
        }
        List list = Headers.parseList((String)tldHeader);
        for (AttributedValue av : list) {
            URL entry;
            String tld = av.getValue();
            if (!tld.startsWith("/")) {
                tld = "/" + tld;
            }
            if ((entry = bundle.getEntry(tld)) == null) {
                logger.warn("Failed to resolve - {}", (Object)tld);
                continue;
            }
            String key = TagLibTracker.makeKey(tld);
            logger.info("Found tag lib  {} in bundle {} (as '{}')", new Object[]{tld, bundle, key});
            tlds.put(key, entry);
        }
        return true;
    }

    private boolean fillFromPlainBundle(Bundle bundle, Map<String, URL> tlds) {
        boolean added = false;
        Enumeration paths = bundle.getEntryPaths("/META-INF/");
        while (paths.hasMoreElements()) {
            String name = (String)paths.nextElement();
            if (!name.endsWith(".tld")) continue;
            String key = TagLibTracker.makeKey(name);
            URL entry = bundle.getEntry(name);
            if (entry == null) continue;
            logger.debug("Add plain mapping {} -> {} / {}", new Object[]{key, name, entry});
            tlds.put(key, entry);
            added = true;
        }
        return added;
    }

    protected TagLibInfo createTagLibInfo(Bundle bundle) {
        logger.trace("Checking for tag lib directories: {}", (Object)bundle);
        HashMap<String, URL> tlds = new HashMap<String, URL>();
        if (!this.fillFromExportHeader(bundle, "Web-Export-Taglib", tlds)) {
            this.fillFromPlainBundle(bundle, tlds);
        }
        if (tlds.isEmpty()) {
            return null;
        }
        return new TagLibInfo(tlds);
    }

    private static String makeKey(String tld) {
        String[] toks = tld.split("\\/");
        return toks[toks.length - 1];
    }

    public void open() {
        this.bundleTracker.open();
    }

    public void close() {
        this.bundleTracker.close();
    }

    @Override
    public Set<String> getPaths(String path) {
        if (!path.equals(this.mappedPrefix)) {
            return null;
        }
        HashSet<String> result = new HashSet<String>();
        for (TagLibInfo tli : this.bundleTracker.getTracked().values()) {
            for (String name : tli.getEntries()) {
                result.add(String.valueOf(this.mappedPrefix) + name);
            }
        }
        return result;
    }

    @Override
    public URL getResource(String name) {
        logger.trace("Getting resource: {}", (Object)name);
        if (!name.startsWith(this.mappedPrefix)) {
            return null;
        }
        String tldName = name.substring(this.mappedPrefix.length());
        for (TagLibInfo tli : this.bundleTracker.getTracked().values()) {
            URL result = tli.getTlds().get(tldName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static class TagLibInfo {
        private final Map<String, URL> tlds;

        public TagLibInfo(Map<String, URL> tlds) {
            this.tlds = tlds;
        }

        public String toString() {
            return String.format("[TagLib - tlds: %s]", this.tlds);
        }

        public Set<String> getEntries() {
            return this.tlds.keySet();
        }

        public Map<String, URL> getTlds() {
            return this.tlds;
        }
    }
}

