/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.sec.service.admin;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.packagedrone.sec.UserInformation;
import org.eclipse.packagedrone.sec.service.LoginException;
import org.eclipse.packagedrone.sec.service.UserService;
import org.eclipse.packagedrone.sec.service.common.Users;
import org.eclipse.scada.utils.ExceptionHelper;

public class GodModeService
implements UserService {
    private static final String PROP_BASE = "package.drone";
    private static final String PROP_NOT_POSIX = "package.drone.admin.announce.file.notPosix";
    private final String adminSalt;
    private final String adminTokenHash;
    private static final String NAME = System.getProperty("package.drone.admin.user", "admin");
    private static final Set<String> ROLES;
    private static final boolean ANNOUNCE_CONSOLE;
    private static final File ANNOUNCE_FILE;
    private static final boolean ANNOUNCE_FILE_POSIX;
    private static final boolean ENABLED;
    private static final String EXTERNAL_ADMIN_TOKEN_HASH;
    private static final String EXTERNAL_ADMIN_TOKEN_SALT;

    static {
        ANNOUNCE_CONSOLE = !Boolean.getBoolean("package.drone.admin.disableAnnounce.console");
        ANNOUNCE_FILE_POSIX = !Boolean.getBoolean(PROP_NOT_POSIX);
        ENABLED = !Boolean.getBoolean("package.drone.admin.disabled");
        String externalAdminToken = System.getProperty("package.drone.admin.token", System.getenv("PACKAGE_DRONE_ADMIN_TOKEN"));
        if (externalAdminToken != null && !externalAdminToken.isEmpty()) {
            EXTERNAL_ADMIN_TOKEN_SALT = Users.createToken((int)32);
            EXTERNAL_ADMIN_TOKEN_HASH = Users.hashIt((String)EXTERNAL_ADMIN_TOKEN_SALT, (String)externalAdminToken);
        } else {
            EXTERNAL_ADMIN_TOKEN_SALT = null;
            EXTERNAL_ADMIN_TOKEN_HASH = null;
        }
        ROLES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(System.getProperty("package.drone.admin.roles", "ADMIN, USER").split("\\s*,\\s*"))));
        String file = System.getProperty("package.drone.admin.announce.file");
        String userDir = System.getProperty("user.home");
        ANNOUNCE_FILE = file != null ? new File(file) : (userDir != null ? new File(new File(userDir), ".drone-admin-token") : null);
    }

    public GodModeService() {
        String adminToken = Users.createToken((int)32);
        this.adminSalt = Users.createToken((int)32);
        this.adminTokenHash = Users.hashIt((String)this.adminSalt, (String)adminToken);
        if (ENABLED) {
            this.announce(adminToken);
        }
    }

    public UserInformation checkCredentials(String username, String credentials, boolean rememberMe) throws LoginException {
        if (!ENABLED) {
            return null;
        }
        if (!NAME.equals(username)) {
            return null;
        }
        String hashedPassword = Users.hashIt((String)this.adminSalt, (String)credentials);
        if (hashedPassword.equals(this.adminTokenHash)) {
            return this.getUserInformation();
        }
        if (EXTERNAL_ADMIN_TOKEN_HASH != null && Users.hashIt((String)EXTERNAL_ADMIN_TOKEN_SALT, (String)credentials).equals(EXTERNAL_ADMIN_TOKEN_HASH)) {
            return this.getUserInformation();
        }
        return null;
    }

    private UserInformation getUserInformation() {
        return new UserInformation(NAME, ROLES);
    }

    public UserInformation refresh(UserInformation user) {
        return null;
    }

    private void announce(String adminToken) {
        if (ANNOUNCE_CONSOLE) {
            System.out.println("=================== Admin>> ===================");
            System.out.println("     User: " + NAME);
            System.out.println(" Password: " + adminToken);
            System.out.println("=================== <<Admin ===================");
        }
        if (ANNOUNCE_FILE != null) {
            this.writeAnnounceFile(adminToken);
        }
    }

    protected void writeAnnounceFile(String adminToken) {
        FileAttribute[] attrs;
        Path path = ANNOUNCE_FILE.toPath();
        ANNOUNCE_FILE.delete();
        if (ANNOUNCE_FILE_POSIX) {
            EnumSet<PosixFilePermission> perms = EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE);
            attrs = new FileAttribute[]{PosixFilePermissions.asFileAttribute(perms)};
        } else {
            attrs = new FileAttribute[]{};
        }
        EnumSet<StandardOpenOption> options = EnumSet.of(StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (SeekableByteChannel sbc = Files.newByteChannel(path, options, attrs);){
                StringWriter sw = new StringWriter();
                PrintWriter writer = new PrintWriter(sw);
                writer.format("user=%s%n", NAME);
                writer.format("password=%s%n", adminToken);
                writer.close();
                ByteBuffer data = ByteBuffer.wrap(sw.toString().getBytes(StandardCharsets.UTF_8));
                while (data.hasRemaining()) {
                    sbc.write(data);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            System.err.format("WARNING: Failed to write out announce file with secured posix permissions. If you are on a non-posix platform (e.g. Windows), you might need to set the system property '%s' to 'true'%n", PROP_NOT_POSIX);
        }
        catch (IOException e) {
            System.err.println("WARNING: Unable to write announce file: " + ExceptionHelper.getMessage((Throwable)e));
        }
    }

    public boolean hasUserBase() {
        return false;
    }
}

