/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.controller.binding;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.packagedrone.utils.converter.ConverterManager;
import org.eclipse.packagedrone.utils.reflect.TypeResolver;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.controller.binding.BindTarget;
import org.eclipse.packagedrone.web.controller.binding.Binder;
import org.eclipse.packagedrone.web.controller.binding.Binding;
import org.eclipse.packagedrone.web.controller.binding.BindingError;
import org.eclipse.packagedrone.web.controller.binding.BindingManagerBinder;
import org.eclipse.packagedrone.web.controller.binding.BindingResult;
import org.eclipse.packagedrone.web.controller.binding.MapBinder;
import org.eclipse.packagedrone.web.controller.binding.ParameterBindTarget;
import org.eclipse.packagedrone.web.controller.binding.PropertyBindTarget;
import org.eclipse.packagedrone.web.controller.binding.SimpleBindingResult;
import org.eclipse.packagedrone.web.controller.validator.ValidationResult;
import org.eclipse.packagedrone.web.controller.validator.Validator;

public class BindingManager {
    private final ConverterManager converter;
    private final Collection<Binder> binders = new LinkedList<Binder>();
    private Validator validator;
    private final Result result = new Result();

    public BindingManager() {
        this.converter = ConverterManager.create();
    }

    public static final BindingManager create(Map<String, Object> data) {
        BindingManager result = new BindingManager();
        result.addBinder(new MapBinder(data));
        result.addBinder(new BindingManagerBinder());
        return result;
    }

    protected Binding bindValue(BindTarget target, ConverterManager converter) {
        for (Binder binder : this.binders) {
            Binding binding = binder.performBind(target, converter, this);
            if (binding == null) continue;
            return binding;
        }
        return Binding.simpleBinding(converter.getDefault(target.getType()));
    }

    private BindTarget createParameterTarget(Parameter parameter, Object[] args, int argumentIndex, TypeResolver typeResolver) {
        return new ParameterBindTarget(parameter, args, argumentIndex, typeResolver);
    }

    protected BindTarget createPropertyTarget(Object object, PropertyDescriptor pd) {
        return new PropertyBindTarget(object, pd);
    }

    public Call bind(final Method method, final Object targetObject) {
        Objects.requireNonNull(method);
        Objects.requireNonNull(targetObject);
        TypeResolver typeResolver = new TypeResolver(targetObject.getClass());
        Parameter[] p = method.getParameters();
        final Binding[] bindings = new Binding[p.length];
        final Object[] args = new Object[p.length];
        int i = 0;
        while (i < p.length) {
            BindTarget target = this.createParameterTarget(p[i], args, i, typeResolver);
            Binding binding = this.bindValue(target, this.converter);
            if (binding == null) {
                throw new IllegalStateException(String.format("Unable to bind parameter '%s' (%s)", p[i].getName(), p[i].getType()));
            }
            bindings[i] = binding;
            target.bind(binding);
            BindingManager.mergeErrors(binding.getBindingResult(), this.result);
            ++i;
        }
        return new Call(){

            @Override
            public Object invoke() throws Exception {
                Object result = method.invoke(targetObject, args);
                Binding[] bindingArray = bindings;
                int n = bindings.length;
                int n2 = 0;
                while (n2 < n) {
                    Binding binding = bindingArray[n2];
                    result = binding.postProcess(result);
                    ++n2;
                }
                result = BindingManager.this.postProcess(result);
                return result;
            }
        };
    }

    private static void mergeErrors(BindingResult bindingResult, BindingResult result) {
        if (bindingResult == null) {
            return;
        }
        result.addErrors(bindingResult.getLocalErrors());
        for (Map.Entry<String, BindingResult> child : bindingResult.getChildren().entrySet()) {
            BindingManager.mergeErrors(child.getValue(), result.getChildOrAdd(child.getKey()));
        }
    }

    protected Object postProcess(Object result) {
        if (result instanceof ModelAndView) {
            ((ModelAndView)result).put(BindingResult.ATTRIBUTE_NAME, this.result);
        }
        return result;
    }

    public void addBinder(Binder binder, boolean initializeBinder) {
        if (initializeBinder) {
            this.initializeBinder(binder);
        }
        this.binders.add(binder);
    }

    public void addBinder(Binder binder) {
        this.addBinder(binder, true);
    }

    private void initializeBinder(Binder binder) {
        Method[] methodArray = binder.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.isAnnotationPresent(Binder.Initializer.class)) {
                Call call = this.bind(m, binder);
                try {
                    call.invoke();
                }
                catch (Exception e) {
                    throw new RuntimeException(String.format("Failed to initialze binder: %s # %s", binder, m), e);
                }
            }
            ++n2;
        }
    }

    public void bindProperties(Object o) throws Exception {
        if (o == null) {
            return;
        }
        Class<?> objectClass = o.getClass();
        BeanInfo bi = Introspector.getBeanInfo(objectClass);
        PropertyDescriptor[] propertyDescriptorArray = bi.getPropertyDescriptors();
        int n = propertyDescriptorArray.length;
        int n2 = 0;
        while (n2 < n) {
            BindTarget target;
            Binding binding;
            PropertyDescriptor pd = propertyDescriptorArray[n2];
            if (pd.getWriteMethod() != null && (binding = this.bindValue(target = this.createPropertyTarget(o, pd), this.converter)) != null) {
                target.bind(binding);
                this.result.addChild(pd.getName(), binding.getBindingResult());
            }
            ++n2;
        }
        this.validate(o);
    }

    protected void validate(Object o) {
        if (this.validator == null) {
            return;
        }
        ValidationResult vr = this.validator.validate(o);
        for (Map.Entry<String, List<BindingError>> entry : vr.getErrors().entrySet()) {
            this.result.addErrors(entry.getKey(), entry.getValue());
        }
        this.result.addMarkers(vr.getMarkers());
    }

    public BindingResult getResult() {
        return this.result;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public static interface Call {
        public Object invoke() throws Exception;
    }

    public static class Result
    extends SimpleBindingResult {
    }
}

