/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.controller.binding;

import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.packagedrone.utils.reflect.TypeResolver;
import org.eclipse.packagedrone.web.controller.binding.BindTarget;
import org.eclipse.packagedrone.web.controller.binding.Binding;

public class ParameterBindTarget
implements BindTarget {
    private final Parameter parameter;
    private final Object[] args;
    private final int argumentIndex;
    private final TypeResolver typeResolver;

    public ParameterBindTarget(Parameter parameter, Object[] args, int argumentIndex, TypeResolver typeResolver) {
        this.parameter = parameter;
        this.args = args;
        this.argumentIndex = argumentIndex;
        this.typeResolver = typeResolver;
    }

    @Override
    public Class<?> getType() {
        Type result;
        if (this.typeResolver != null && (result = this.typeResolver.resolveParameterType(this.parameter)) instanceof Class) {
            return (Class)result;
        }
        return this.parameter.getType();
    }

    @Override
    public String getQualifier() {
        return null;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> clazz) {
        return this.parameter.isAnnotationPresent(clazz);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        return this.parameter.getAnnotation(clazz);
    }

    @Override
    public <T extends Annotation> Collection<T> getAnnotationsByType(Class<T> annotationClass) {
        return Arrays.asList(this.parameter.getAnnotationsByType(annotationClass));
    }

    @Override
    public void bind(Binding binding) {
        this.args[this.argumentIndex] = binding.getValue();
    }
}

