/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.manage.core.apm;

import java.io.BufferedReader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.manage.core.apm.CoreServiceModel;
import org.eclipse.packagedrone.repo.manage.core.apm.CoreServiceViewModel;
import org.eclipse.packagedrone.storage.apm.AbstractSimpleStorageModelProvider;
import org.eclipse.packagedrone.storage.apm.StorageContext;
import org.eclipse.packagedrone.storage.apm.util.ReplaceOnCloseWriter;

public class CoreStorageModelProvider
extends AbstractSimpleStorageModelProvider<CoreServiceViewModel, CoreServiceModel> {
    public CoreStorageModelProvider() {
        super(CoreServiceModel.class);
    }

    public CoreServiceModel cloneWriteModel(CoreServiceModel writeModel) {
        return new CoreServiceModel(writeModel);
    }

    protected CoreServiceViewModel makeViewModelTyped(CoreServiceModel writeModel) {
        return new CoreServiceViewModel(writeModel.getProperties());
    }

    protected void persistWriteModel(StorageContext context, CoreServiceModel writeModel) throws Exception {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ReplaceOnCloseWriter writer = new ReplaceOnCloseWriter(this.makePath(context), StandardCharsets.UTF_8);){
            Properties p = new Properties();
            for (Map.Entry<MetaKey, String> entry : writeModel.getProperties().entrySet()) {
                String value = entry.getValue();
                if (value == null) continue;
                p.put(entry.getKey().toString(), entry.getValue());
            }
            p.store((Writer)writer, null);
            writer.commit();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected CoreServiceModel loadWriteModel(StorageContext context) throws Exception {
        Properties p = new Properties();
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (BufferedReader reader = Files.newBufferedReader(this.makePath(context));){
                p.load(reader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (NoSuchFileException noSuchFileException) {}
        HashMap<MetaKey, String> result = new HashMap<MetaKey, String>(p.size());
        for (String key : p.stringPropertyNames()) {
            MetaKey metaKey = MetaKey.fromString((String)key);
            result.put(metaKey, p.getProperty(key));
        }
        return new CoreServiceModel(result);
    }

    private Path makePath(StorageContext context) {
        return context.getBasePath().resolve("core.properties");
    }
}

