/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.trigger.cleanup.internal;

import org.eclipse.packagedrone.repo.channel.ModifiableChannel;
import org.eclipse.packagedrone.repo.trigger.Processor;
import org.eclipse.packagedrone.repo.trigger.ProcessorFactory;
import org.eclipse.packagedrone.repo.trigger.cleanup.CleanupConfiguration;
import org.eclipse.packagedrone.repo.trigger.cleanup.internal.CleanupConfigurationController;
import org.eclipse.packagedrone.repo.trigger.cleanup.internal.CleanupProcessor;
import org.eclipse.packagedrone.web.LinkTarget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanupProcessorFactory
implements ProcessorFactory {
    static final Class<?>[] SUPPORTED_CONTEXTS = new Class[]{ModifiableChannel.class};
    private static final Logger logger = LoggerFactory.getLogger(CleanupProcessorFactory.class);
    public static final String ID = "cleanup";

    public Class<?>[] getSupportedContexts() {
        return SUPPORTED_CONTEXTS;
    }

    public Processor create(String configuration) {
        return new CleanupProcessor(CleanupConfiguration.valueOf(configuration));
    }

    public String getLabel() {
        return "Channel cleanup";
    }

    public String getDescription() {
        return "Delete artifacts from a channel by a defined aggregation and sort configuration";
    }

    public String getConfigurationUrl() {
        try {
            return LinkTarget.createFromController(CleanupConfigurationController.class, (String)"configure").getUrl();
        }
        catch (Exception e) {
            logger.warn("Failed to generate configuration url", (Throwable)e);
            return null;
        }
    }
}

