/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.util.filesystem.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipFile;
import org.apache.aries.util.filesystem.IFile;
import org.apache.aries.util.filesystem.impl.CloseableDirectory;
import org.apache.aries.util.filesystem.impl.NestedZipDirectory;
import org.apache.aries.util.io.IOUtils;

public class NestedCloseableDirectory
extends CloseableDirectory {
    private final File tempFile = File.createTempFile("archiveExtract", ".jar");
    private final ZipFile zip;

    public NestedCloseableDirectory(IFile archive, NestedZipDirectory delegate) throws IOException {
        super(delegate);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.tempFile);
            IOUtils.copy(archive.open(), fos);
            this.delegate = new NestedZipDirectory(delegate, this);
            this.zip = new ZipFile(this.tempFile);
        }
        catch (IOException e) {
            IOUtils.close(fos);
            this.tempFile.delete();
            throw e;
        }
    }

    public ZipFile getZipFile() {
        return this.zip;
    }

    protected void cleanup() {
        try {
            this.zip.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.tempFile.delete();
    }
}

