/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.utils.osgi.feature;

import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.packagedrone.repo.utils.osgi.ParserHelper;
import org.eclipse.packagedrone.repo.utils.osgi.feature.FeatureInformation;
import org.eclipse.packagedrone.repo.xml.XmlHelper;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FeatureInformationParser {
    private static final Logger logger = LoggerFactory.getLogger(FeatureInformationParser.class);
    private final ZipFile file;
    private final XmlHelper xml = new XmlHelper();

    public FeatureInformationParser(ZipFile file) {
        this.file = file;
    }

    public FeatureInformation parse() throws IOException {
        Document doc;
        ZipEntry ze = this.file.getEntry("feature.xml");
        if (ze == null) {
            logger.debug("There is no feature.xml in the archive");
            return null;
        }
        Throwable throwable = null;
        Object var4_4 = null;
        try (InputStream is = this.file.getInputStream(ze);){
            try {
                doc = this.xml.parse(is);
            }
            catch (Exception e) {
                logger.info("Failed to parse feature.xml", (Throwable)e);
                if (is != null) {
                    is.close();
                }
                return null;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Element root = doc.getDocumentElement();
        String id = this.makeNull(root.getAttribute("id"));
        if (id == null) {
            logger.info("Feature ID is not set");
            return null;
        }
        String version = this.makeNull(root.getAttribute("version"));
        if (version == null) {
            logger.info("Feature version is not set");
            return null;
        }
        FeatureInformation result = new FeatureInformation();
        result.setId(id);
        result.setVersion(new Version(version));
        result.setProvider(this.makeNull(root.getAttribute("provider-name")));
        result.setLabel(this.makeNull(root.getAttribute("label")));
        result.setPlugin(this.makeNull(root.getAttribute("plugin")));
        result.setQualifiers(FeatureInformation.Qualifiers.parse(root));
        for (Node node : XmlHelper.iter((NodeList)root.getChildNodes())) {
            if (!(node instanceof Element)) continue;
            Element ele = (Element)node;
            if ("description".equals(node.getNodeName())) {
                result.setDescriptionUrl(this.makeNull(ele.getAttribute("url")));
                result.setDescription(this.trim(ele.getTextContent()));
            }
            if ("copyright".equals(node.getNodeName())) {
                result.setCopyrightUrl(this.makeNull(ele.getAttribute("url")));
                result.setCopyright(this.trim(ele.getTextContent()));
            }
            if ("license".equals(node.getNodeName())) {
                result.setLicenseUrl(this.makeNull(ele.getAttribute("url")));
                result.setLicense(this.trim(ele.getTextContent()));
            }
            if ("includes".equals(node.getNodeName())) {
                this.processFeatureInclude(result, ele);
            }
            if ("requires".equals(node.getNodeName())) {
                this.processRequirements(result, ele);
            }
            if (!"plugin".equals(node.getNodeName())) continue;
            this.processPluginInclude(result, ele);
        }
        this.attachLocalization(result);
        return result;
    }

    private String trim(String text) {
        if (text == null) {
            return text;
        }
        return text.trim();
    }

    private String makeNull(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        return value;
    }

    private void processRequirements(FeatureInformation result, Element ele) {
        Set<FeatureInformation.Requirement> reqs = result.getRequirements();
        for (Element im : XmlHelper.iterElement((Element)ele, (String)"import")) {
            String feature = im.getAttribute("feature");
            String plugin = im.getAttribute("plugin");
            String vs = this.makeNull(im.getAttribute("version"));
            FeatureInformation.Requirement.MatchRule match = this.makeMatch(im.getAttribute("match"));
            Version version = null;
            if (vs != null) {
                version = new Version(vs);
            }
            FeatureInformation.Requirement req = feature != null && !feature.isEmpty() ? new FeatureInformation.Requirement(FeatureInformation.Requirement.Type.FEATURE, feature, version, match) : new FeatureInformation.Requirement(FeatureInformation.Requirement.Type.PLUGIN, plugin, version, match);
            reqs.add(req);
        }
    }

    private FeatureInformation.Requirement.MatchRule makeMatch(String matchString) {
        if (matchString == null) {
            return FeatureInformation.Requirement.MatchRule.DEFAULT;
        }
        FeatureInformation.Requirement.MatchRule mr = FeatureInformation.Requirement.MatchRule.findById(matchString);
        if (mr != null) {
            return mr;
        }
        return FeatureInformation.Requirement.MatchRule.DEFAULT;
    }

    private void processPluginInclude(FeatureInformation result, Element ele) {
        String id = ele.getAttribute("id");
        String vs = this.makeNull(ele.getAttribute("version"));
        Version version = new Version(vs == null ? "0.0.0" : vs);
        String unpackAttr = ele.getAttribute("unpack");
        boolean unpack = unpackAttr == null || unpackAttr.isEmpty() ? true : Boolean.parseBoolean(unpackAttr);
        FeatureInformation.Qualifiers q = FeatureInformation.Qualifiers.parse(ele);
        result.getIncludedPlugins().add(new FeatureInformation.PluginInclude(id, version, unpack, q));
    }

    private void processFeatureInclude(FeatureInformation result, Element ele) {
        String id = ele.getAttribute("id");
        String vs = this.makeNull(ele.getAttribute("version"));
        Version version = new Version(vs == null ? "0.0.0" : vs);
        String name = this.makeNull(ele.getAttribute("name"));
        boolean optional = Boolean.parseBoolean(ele.getAttribute("optional"));
        FeatureInformation.Qualifiers q = FeatureInformation.Qualifiers.parse(ele);
        result.getIncludedFeatures().add(new FeatureInformation.FeatureInclude(id, version, name, optional, q));
    }

    private void attachLocalization(FeatureInformation result) throws IOException {
        result.setLocalization(ParserHelper.loadLocalization(this.file, "feature"));
    }
}

