/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.r5;

import java.io.IOException;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.packagedrone.VersionInformation;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.aspect.common.osgi.OsgiAspectFactory;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.utils.osgi.bundle.BundleInformation;
import org.eclipse.packagedrone.utils.Filters;
import org.eclipse.packagedrone.utils.io.IOConsumer;
import org.eclipse.packagedrone.utils.io.OutputSpooler;
import org.eclipse.packagedrone.utils.io.SpoolOutTarget;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public class RepositoryCreator {
    private static final MetaKey KEY_SHA_256 = new MetaKey("hasher", "sha256");
    private static final DateFormat OBR_DATE_FORMAT = new SimpleDateFormat("YYYYMMDDHHmmss.SSS");
    private static final String FRAMEWORK_PACKAGE = "org.osgi.framework";
    private final OutputSpooler indexStreamBuilder;
    private final String name;
    private final Function<ArtifactInformation, String> urlProvider;
    private final Supplier<XMLOutputFactory> outputFactory;
    private final OutputSpooler obrStreamBuilder;

    private static void addIndexIdentity(XMLStreamWriter writer, BundleInformation bi) throws XMLStreamException {
        HashMap<String, Object> caps = new HashMap<String, Object>();
        caps.put("osgi.identity", bi.getId());
        caps.put("version", bi.getVersion());
        caps.put("type", "osgi.bundle");
        RepositoryCreator.addIndexCapabilityRaw(writer, "osgi.identity", caps);
    }

    public static void addIndexDependencies(XMLStreamWriter writer, BundleInformation bi) throws XMLStreamException {
        HashMap<String, Object> caps;
        String filter;
        HashMap<String, String> reqs;
        LinkedList<Filters.Node> nodes = new LinkedList<Filters.Node>();
        for (String ee : bi.getRequiredExecutionEnvironments()) {
            nodes.add(Filters.pair((String)"osgi.ee", (String)ee));
        }
        if (!nodes.isEmpty()) {
            HashMap<String, String> reqs2 = new HashMap<String, String>(1);
            reqs2.put("filter", Filters.or(nodes));
            RepositoryCreator.addIndexRequirement(writer, "osgi.ee", reqs2);
        }
        HashMap<String, Object> caps2 = new HashMap<String, Object>();
        caps2.put("osgi.wiring.bundle", bi.getId());
        caps2.put("bundle-version", bi.getVersion());
        RepositoryCreator.addIndexCapabilityRaw(writer, "osgi.wiring.bundle", caps2);
        caps2 = new HashMap();
        caps2.put("osgi.wiring.host", bi.getId());
        caps2.put("bundle-version", bi.getVersion());
        RepositoryCreator.addIndexCapabilityRaw(writer, "osgi.wiring.host", caps2);
        for (BundleInformation.BundleRequirement br : bi.getBundleRequirements()) {
            reqs = new HashMap<String, String>();
            filter = Filters.and((Filters.Node[])new Filters.Node[]{Filters.pair((String)"osgi.wiring.bundle", (String)br.getId()), Filters.versionRange((String)"bundle-version", (VersionRange)br.getVersionRange())});
            reqs.put("filter", filter);
            if (br.isOptional()) {
                reqs.put("resolution", "optional");
            }
            RepositoryCreator.addIndexRequirement(writer, "osgi.wiring.bundle", reqs);
        }
        for (BundleInformation.PackageExport pe : bi.getPackageExports()) {
            Version specVersion;
            caps = new HashMap<String, Object>();
            caps.put("osgi.wiring.package", pe.getName());
            if (pe.getVersion() != null) {
                caps.put("version", pe.getVersion());
            }
            RepositoryCreator.addIndexCapabilityRaw(writer, "osgi.wiring.package", caps);
            if (!FRAMEWORK_PACKAGE.equals(pe.getName()) || (specVersion = RepositoryCreator.mapFrameworkPackageVersion(pe.getVersion())) == null) continue;
            HashMap<String, Object> frameworkCaps = new HashMap<String, Object>();
            frameworkCaps.put("osgi.contract", "OSGiFramework");
            frameworkCaps.put("version", specVersion);
            RepositoryCreator.addIndexCapabilityRaw(writer, "osgi.contract", frameworkCaps);
        }
        for (BundleInformation.PackageImport pi : bi.getPackageImports()) {
            reqs = new HashMap();
            filter = Filters.and((Filters.Node[])new Filters.Node[]{Filters.pair((String)"osgi.wiring.package", (String)pi.getName()), Filters.versionRange((String)"version", (VersionRange)pi.getVersionRange())});
            reqs.put("filter", filter);
            if (pi.isOptional()) {
                reqs.put("resolution", "optional");
            }
            RepositoryCreator.addIndexRequirement(writer, "osgi.wiring.package", reqs);
        }
        for (BundleInformation.ProvideCapability pc : bi.getProvidedCapabilities()) {
            RepositoryCreator.addIndexCapability(writer, pc.getNamespace(), pc.getValues());
        }
        for (BundleInformation.RequireCapability rc : bi.getRequiredCapabilities()) {
            caps = new HashMap();
            caps.put("filter", rc.getFilter());
            if (rc.getEffective() != null && !rc.getEffective().isEmpty()) {
                caps.put("effective", rc.getEffective());
            }
            RepositoryCreator.addIndexRequirement(writer, rc.getNamespace(), caps);
        }
    }

    public static void addObrDependencies(XMLStreamWriter writer, BundleInformation bi) throws XMLStreamException {
        String filter;
        LinkedList<Filters.Node> nodes = new LinkedList<Filters.Node>();
        for (String ee : bi.getRequiredExecutionEnvironments()) {
            nodes.add(Filters.pair((String)"ee", (String)ee));
        }
        if (!nodes.isEmpty()) {
            String filter2 = Filters.or(nodes);
            RepositoryCreator.addObrRequirement(writer, "ee", filter2, false, false, false, String.format("Execution Environment %s", filter2));
        }
        HashMap<String, Object> caps = new HashMap<String, Object>();
        caps.put("symbolicname", bi.getId());
        if (bi.getName() != null) {
            caps.put("presentationname", bi.getName());
        }
        caps.put("version", bi.getVersion());
        caps.put("manifestversion", "2");
        RepositoryCreator.addObrCapability(writer, "bundle", caps);
        for (BundleInformation.BundleRequirement br : bi.getBundleRequirements()) {
            filter = Filters.and((Filters.Node[])new Filters.Node[]{Filters.pair((String)"symbolicname", (String)br.getId()), Filters.versionRange((String)"version", (VersionRange)br.getVersionRange())});
            RepositoryCreator.addObrRequirement(writer, "bundle", filter, false, false, br.isOptional(), br.toString());
        }
        for (BundleInformation.PackageExport pe : bi.getPackageExports()) {
            HashMap<String, Object> caps2 = new HashMap<String, Object>();
            caps2.put("package", pe.getName());
            if (pe.getVersion() != null) {
                caps2.put("version", pe.getVersion());
            } else {
                caps2.put("version", "0.0.0");
            }
            if (pe.getUses() != null) {
                caps2.put(":uses", pe.getUses());
            }
            RepositoryCreator.addObrCapability(writer, "package", caps2);
        }
        for (BundleInformation.PackageImport pi : bi.getPackageImports()) {
            filter = Filters.and((Filters.Node[])new Filters.Node[]{Filters.pair((String)"package", (String)pi.getName()), Filters.versionRange((String)"version", (VersionRange)pi.getVersionRange())});
            RepositoryCreator.addObrRequirement(writer, "package", filter, false, false, pi.isOptional(), pi.toString());
        }
    }

    private static void addIndexRequirement(XMLStreamWriter writer, String id, Map<String, String> caps) throws XMLStreamException {
        writer.writeCharacters("\t");
        writer.writeStartElement("requirement");
        writer.writeAttribute("namespace", id);
        writer.writeCharacters("\n");
        for (Map.Entry<String, String> entry : caps.entrySet()) {
            writer.writeCharacters("\t\t");
            writer.writeEmptyElement("directive");
            writer.writeAttribute("name", entry.getKey());
            writer.writeAttribute("value", entry.getValue());
            writer.writeCharacters("\n");
        }
        writer.writeCharacters("\t");
        writer.writeEndElement();
        writer.writeCharacters("\n");
    }

    private static void addObrRequirement(XMLStreamWriter writer, String id, String filter, boolean extend, boolean multiple, boolean optional, String text) throws XMLStreamException {
        writer.writeCharacters("\t");
        writer.writeStartElement("require");
        writer.writeAttribute("name", id);
        writer.writeAttribute("filter", filter);
        writer.writeAttribute("extend", Boolean.toString(extend));
        writer.writeAttribute("multiple", Boolean.toString(multiple));
        writer.writeAttribute("optional", Boolean.toString(optional));
        writer.writeCharacters(text);
        writer.writeEndElement();
        writer.writeCharacters("\n");
    }

    private static void addIndexContent(XMLStreamWriter writer, ArtifactInformation a, String url) throws XMLStreamException {
        String sha256 = (String)a.getMetaData().get(KEY_SHA_256);
        if (sha256 == null) {
            return;
        }
        HashMap<String, Object> caps = new HashMap<String, Object>(4);
        caps.put("osgi.content", sha256);
        caps.put("size", a.getSize());
        caps.put("mime", "application/vnd.osgi.bundle");
        caps.put("url", url);
        RepositoryCreator.addIndexCapabilityRaw(writer, "osgi.content", caps);
    }

    private static void addIndexCapabilityRaw(XMLStreamWriter writer, String id, Map<String, Object> caps) throws XMLStreamException {
        HashMap<String, BundleInformation.CapabilityValue> newCaps = new HashMap<String, BundleInformation.CapabilityValue>(caps.size());
        for (Map.Entry<String, Object> entry : caps.entrySet()) {
            String value;
            String type;
            Object rawValue = entry.getValue();
            if (rawValue instanceof Collection) {
                Collection col = (Collection)rawValue;
                if (!col.isEmpty()) {
                    Object first = col.iterator().next();
                    type = String.format("List<%>", first.getClass().getSimpleName());
                    value = col.stream().map(Object::toString).collect(Collectors.joining(", "));
                } else {
                    type = null;
                    value = null;
                }
            } else {
                type = rawValue.getClass().getSimpleName();
                value = entry.getValue().toString();
            }
            if (value == null) continue;
            newCaps.put(entry.getKey(), new BundleInformation.CapabilityValue(type, value));
        }
        RepositoryCreator.addIndexCapability(writer, id, newCaps);
    }

    private static void addIndexCapability(XMLStreamWriter writer, String id, Map<String, BundleInformation.CapabilityValue> caps) throws XMLStreamException {
        writer.writeCharacters("\t");
        writer.writeStartElement("capability");
        writer.writeAttribute("namespace", id);
        writer.writeCharacters("\n");
        for (Map.Entry<String, BundleInformation.CapabilityValue> entry : caps.entrySet()) {
            writer.writeCharacters("\t\t");
            writer.writeEmptyElement("attribute");
            writer.writeAttribute("name", entry.getKey());
            if (!entry.getValue().getType().equals("String")) {
                writer.writeAttribute("type", entry.getValue().getType());
            }
            writer.writeAttribute("value", entry.getValue().getValue());
            writer.writeCharacters("\n");
        }
        writer.writeCharacters("\t");
        writer.writeEndElement();
        writer.writeCharacters("\n");
    }

    private static void addObrCapability(XMLStreamWriter writer, String id, Map<String, Object> caps) throws XMLStreamException {
        writer.writeCharacters("\t");
        writer.writeStartElement("capability");
        writer.writeAttribute("name", id);
        writer.writeCharacters("\n");
        for (Map.Entry<String, Object> entry : caps.entrySet()) {
            writer.writeCharacters("\t\t");
            writer.writeEmptyElement("p");
            writer.writeAttribute("n", entry.getKey());
            Object v = entry.getValue();
            if (v instanceof Version) {
                writer.writeAttribute("t", v.getClass().getSimpleName().toLowerCase());
            }
            writer.writeAttribute("v", "" + v);
            writer.writeCharacters("\n");
        }
        writer.writeCharacters("\t");
        writer.writeEndElement();
        writer.writeCharacters("\n");
    }

    public RepositoryCreator(String name, SpoolOutTarget target, Function<ArtifactInformation, String> urlProvider, Supplier<XMLOutputFactory> outputFactory) {
        this.name = name;
        this.urlProvider = urlProvider;
        this.outputFactory = outputFactory;
        this.indexStreamBuilder = new OutputSpooler(target);
        this.indexStreamBuilder.addOutput("index.xml", "application/xml");
        this.obrStreamBuilder = new OutputSpooler(target);
        this.obrStreamBuilder.addOutput("obr.xml", "application/xml");
    }

    public RepositoryCreator(String name, SpoolOutTarget target, Function<ArtifactInformation, String> urlProvider) {
        this(name, target, urlProvider, XMLOutputFactory::newFactory);
    }

    public void process(IOConsumer<Context> consumer) throws IOException {
        XMLOutputFactory xml = this.outputFactory.get();
        this.indexStreamBuilder.open(indexStream -> this.obrStreamBuilder.open(obrStream -> {
            try {
                this.processStreams(consumer, xml, (OutputStream)indexStream, (OutputStream)obrStream);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }));
    }

    private void processStreams(IOConsumer<Context> consumer, XMLOutputFactory xml, OutputStream indexStream, OutputStream obrStream) throws XMLStreamException, IOException {
        XMLStreamWriter indexWriter = xml.createXMLStreamWriter(indexStream);
        XMLStreamWriter obrWriter = xml.createXMLStreamWriter(obrStream);
        try {
            this.startIndex(indexWriter);
            this.startObr(obrWriter);
            ContextImpl ctx = new ContextImpl(indexWriter, obrWriter, this.urlProvider);
            consumer.accept((Object)ctx);
            this.endObr(obrWriter);
            this.endIndex(indexWriter);
        }
        finally {
            indexWriter.close();
            obrWriter.close();
        }
    }

    private void startIndex(XMLStreamWriter xsw) throws XMLStreamException {
        xsw.writeStartDocument();
        xsw.writeCharacters("\n\n");
        xsw.writeComment(String.format("Created by Package Drone %s - %tc", VersionInformation.VERSION, new Date()));
        xsw.writeStartElement("repository");
        xsw.writeDefaultNamespace("http://www.osgi.org/xmlns/repository/v1.0.0");
        xsw.writeAttribute("increment", Long.toString(System.currentTimeMillis()));
        xsw.writeAttribute("name", this.name);
        xsw.writeCharacters("\n\n");
    }

    private void endIndex(XMLStreamWriter xsw) throws XMLStreamException {
        xsw.writeEndElement();
        xsw.writeEndDocument();
    }

    private void startObr(XMLStreamWriter xsw) throws XMLStreamException {
        xsw.writeStartDocument();
        xsw.writeCharacters("\n\n");
        xsw.writeComment(String.format("Created by Package Drone %s - %tc", VersionInformation.VERSION, new Date()));
        xsw.writeStartElement("repository");
        xsw.writeAttribute("lastmodified", OBR_DATE_FORMAT.format(new Date()));
        xsw.writeAttribute("name", this.name);
        xsw.writeCharacters("\n\n");
    }

    private void endObr(XMLStreamWriter xsw) throws XMLStreamException {
        xsw.writeEndElement();
        xsw.writeEndDocument();
    }

    private static Version mapFrameworkPackageVersion(Version pv) {
        Version version;
        if (pv.getMajor() != 1) {
            return null;
        }
        switch (pv.getMinor()) {
            case 7: {
                version = new Version(5, 0, 0);
                break;
            }
            case 6: {
                version = new Version(4, 3, 0);
                break;
            }
            case 5: {
                version = new Version(4, 2, 0);
                break;
            }
            case 4: {
                version = new Version(4, 1, 0);
                break;
            }
            case 3: {
                version = new Version(4, 0, 0);
                break;
            }
            case 2: {
                version = new Version(3, 0, 0);
                break;
            }
            case 1: {
                version = new Version(2, 0, 0);
                break;
            }
            case 0: {
                version = new Version(1, 0, 0);
                break;
            }
            default: {
                version = null;
            }
        }
        return version;
    }

    public static interface Context {
        public void addArtifact(ArtifactInformation var1) throws IOException;
    }

    private static class ContextImpl
    implements Context {
        private final XMLStreamWriter indexWriter;
        private final XMLStreamWriter obrWriter;
        private final Function<ArtifactInformation, String> urlProvider;

        public ContextImpl(XMLStreamWriter indexWriter, XMLStreamWriter obrWriter, Function<ArtifactInformation, String> urlProvider) {
            this.indexWriter = indexWriter;
            this.obrWriter = obrWriter;
            this.urlProvider = urlProvider;
        }

        @Override
        public void addArtifact(ArtifactInformation art) throws IOException {
            Map md = art.getMetaData();
            BundleInformation bi = OsgiAspectFactory.fetchBundleInformation((Map)md);
            if (bi == null) {
                return;
            }
            if (bi.getId() == null || bi.getVersion() == null) {
                return;
            }
            try {
                this.addIndexEntry(art, bi);
                this.addObrEntry(art, bi);
            }
            catch (XMLStreamException e) {
                throw new IOException(e);
            }
        }

        private void addIndexEntry(ArtifactInformation art, BundleInformation bi) throws XMLStreamException {
            this.indexWriter.writeStartElement("resource");
            this.indexWriter.writeCharacters("\n");
            RepositoryCreator.addIndexIdentity(this.indexWriter, bi);
            RepositoryCreator.addIndexContent(this.indexWriter, art, this.urlProvider.apply(art));
            RepositoryCreator.addIndexDependencies(this.indexWriter, bi);
            this.indexWriter.writeEndElement();
            this.indexWriter.writeCharacters("\n\n");
        }

        private void addObrEntry(ArtifactInformation art, BundleInformation bi) throws XMLStreamException {
            this.obrWriter.writeStartElement("resource");
            this.obrWriter.writeAttribute("id", art.getId());
            this.obrWriter.writeAttribute("symbolicname", bi.getId());
            this.obrWriter.writeAttribute("version", "" + bi.getVersion());
            if (bi.getName() != null) {
                this.obrWriter.writeAttribute("presentationname", bi.getName());
            }
            this.obrWriter.writeAttribute("uri", this.urlProvider.apply(art));
            this.obrWriter.writeCharacters("\n");
            ContextImpl.addObrMainTag(this.obrWriter, "size", "" + art.getSize());
            if (bi.getDocUrl() != null && !bi.getDocUrl().isEmpty()) {
                ContextImpl.addObrMainTag(this.obrWriter, "documentation", bi.getDocUrl());
            }
            if (bi.getDescription() != null && !bi.getDescription().isEmpty()) {
                ContextImpl.addObrMainTag(this.obrWriter, "description", bi.getDescription());
            }
            RepositoryCreator.addObrDependencies(this.obrWriter, bi);
            this.obrWriter.writeEndElement();
            this.obrWriter.writeCharacters("\n\n");
        }

        private static void addObrMainTag(XMLStreamWriter obrWriter, String name, String value) throws XMLStreamException {
            if (value == null) {
                return;
            }
            obrWriter.writeCharacters("\t");
            obrWriter.writeStartElement(name);
            obrWriter.writeCharacters(value);
            obrWriter.writeEndElement();
            obrWriter.writeCharacters("\n");
        }
    }
}

