/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.manage.system.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.eclipse.packagedrone.repo.manage.system.ConfigurationBackupService;
import org.eclipse.packagedrone.repo.xml.XmlHelper;
import org.eclipse.packagedrone.utils.converter.ConverterManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConfigurationBackupServiceImpl
implements ConfigurationBackupService {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationBackupServiceImpl.class);
    private static final String BACKUP_VERSION = "1";
    private static final String CFG_FILE_NAME = "configurations.xml";
    private ConfigurationAdmin configAdmin;
    private final Bundle bundle = FrameworkUtil.getBundle(ConfigurationBackupServiceImpl.class);
    private final ConverterManager cvt = new ConverterManager();
    private final Set<String> ignoredFactories = new HashSet<String>(Arrays.asList("gemini.jpa.punit"));

    public void setConfigAdmin(ConfigurationAdmin configAdmin) {
        this.configAdmin = configAdmin;
    }

    @Override
    public void createConfigurationBackup(OutputStream stream) {
        try {
            this.processBackup(stream);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to export backup", e);
        }
    }

    private void processBackup(OutputStream stream) throws Exception {
        ZipOutputStream zos = new ZipOutputStream(stream);
        this.storeConfigurations(zos, this.getAllConfigurations());
        zos.close();
    }

    protected List<Configuration> getAllConfigurations() throws IOException, InvalidSyntaxException {
        Configuration[] result = this.configAdmin.listConfigurations(null);
        if (result == null) {
            return Collections.emptyList();
        }
        LinkedList<Configuration> list = new LinkedList<Configuration>(Arrays.asList(result));
        Iterator i = list.iterator();
        while (i.hasNext()) {
            Configuration cfg = (Configuration)i.next();
            if (!this.ignoredFactories.contains(cfg.getFactoryPid())) continue;
            i.remove();
        }
        return list;
    }

    private void storeConfigurations(ZipOutputStream zos, List<Configuration> cfgs) throws Exception {
        zos.putNextEntry(new ZipEntry(CFG_FILE_NAME));
        XmlHelper xml = new XmlHelper();
        Document doc = xml.create();
        Element root = doc.createElement("configuration");
        doc.appendChild(root);
        root.setAttribute("version", BACKUP_VERSION);
        for (Configuration cfg : cfgs) {
            Element entry = XmlHelper.addElement((Element)root, (String)"entry");
            if (cfg.getFactoryPid() != null) {
                entry.setAttribute("factoryPid", cfg.getFactoryPid());
            } else if (cfg.getPid() != null) {
                entry.setAttribute("pid", cfg.getPid());
            }
            for (String key : Collections.list(cfg.getProperties().keys())) {
                Object value = cfg.getProperties().get(key);
                Element prop = XmlHelper.addElement((Element)entry, (String)"property");
                prop.setAttribute("key", key);
                if (value == null) continue;
                prop.setAttribute("type", value.getClass().getName());
                prop.setTextContent(value.toString());
            }
        }
        xml.write((Node)doc, (OutputStream)zos);
        zos.closeEntry();
    }

    @Override
    public void restoreConfiguration(InputStream stream) throws Exception {
        ZipEntry entry;
        ZipInputStream zis = new ZipInputStream(stream);
        Configurations cfg = null;
        while ((entry = zis.getNextEntry()) != null) {
            if (!CFG_FILE_NAME.equals(entry.getName())) continue;
            cfg = this.parse(zis);
            break;
        }
        if (cfg == null) {
            throw new IllegalStateException(String.format("Unable to find '%s' in the configuration archive", CFG_FILE_NAME));
        }
        this.apply(cfg);
    }

    @Override
    public void provisionConfiguration(InputStream stream) throws Exception {
        this.apply(this.parse(stream));
    }

    private Configurations parse(InputStream stream) throws Exception {
        XmlHelper xml = new XmlHelper();
        Document doc = xml.parse(stream);
        Element root = doc.getDocumentElement();
        if (!BACKUP_VERSION.equals(root.getAttribute("version"))) {
            throw new IllegalArgumentException(String.format("Backup version %s is unsupported", root.getAttribute("version")));
        }
        Configurations cfg = new Configurations();
        for (Element entry : XmlHelper.iterElement((Element)root, (String)"entry")) {
            Entry cfgEntry = new Entry();
            if (!entry.getAttribute("factoryPid").isEmpty()) {
                String factoryPid = entry.getAttribute("factoryPid");
                LinkedList<Entry> list = (LinkedList<Entry>)cfg.factoryEntries.get(factoryPid);
                if (list == null) {
                    list = new LinkedList<Entry>();
                    cfg.factoryEntries.put(factoryPid, list);
                }
                list.add(cfgEntry);
            } else {
                if (entry.getAttribute("pid").isEmpty()) continue;
                String pid = entry.getAttribute("pid");
                cfg.directEntries.put(pid, cfgEntry);
            }
            for (Element p : XmlHelper.iterElement((Element)entry, (String)"property")) {
                String key = p.getAttribute("key");
                String type = p.getAttribute("type");
                String value = p.getTextContent();
                cfgEntry.data.put(key, this.makeValue(type, value));
            }
        }
        return cfg;
    }

    private Object makeValue(String type, String value) throws Exception {
        Class clazz = this.bundle.loadClass(type);
        return this.cvt.convertTo((Object)value, clazz);
    }

    private void apply(Configurations cfg) throws Exception {
        logger.debug("Apply configuration");
        List<Configuration> cfgs = this.getAllConfigurations();
        for (Configuration configuration : cfgs) {
            if (configuration.getFactoryPid() == null) {
                Entry ne = (Entry)cfg.directEntries.remove(configuration.getPid());
                if (ne == null) {
                    logger.debug("Delete direct: {}", (Object)configuration.getPid());
                    configuration.delete();
                    continue;
                }
                logger.debug("Update direct: {} = {}", (Object)configuration.getPid(), (Object)ne.data);
                configuration.update((Dictionary)ne.data);
                continue;
            }
            logger.debug("Update factory: {} / {}", (Object)configuration.getFactoryPid(), (Object)configuration.getPid());
            configuration.delete();
        }
        for (Map.Entry entry : cfg.directEntries.entrySet()) {
            logger.debug("Add direct: {} = {}", entry.getKey(), (Object)((Entry)entry.getValue()).data);
            Configuration conf = this.configAdmin.getConfiguration((String)entry.getKey(), null);
            conf.update((Dictionary)((Entry)entry.getValue()).data);
        }
        for (Map.Entry entry : cfg.factoryEntries.entrySet()) {
            for (Entry ce : (List)entry.getValue()) {
                logger.debug("Add factory: {} = {}", entry.getKey(), (Object)ce.data);
                Configuration conf = this.configAdmin.createFactoryConfiguration((String)entry.getKey(), null);
                conf.update((Dictionary)ce.data);
            }
        }
    }

    private static class Configurations {
        private final Map<String, Entry> directEntries = new HashMap<String, Entry>();
        private final Map<String, List<Entry>> factoryEntries = new HashMap<String, List<Entry>>();

        private Configurations() {
        }
    }

    private static class Entry {
        private final Hashtable<String, Object> data = new Hashtable();

        private Entry() {
        }
    }
}

