/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.sql;

import java.nio.CharBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SqlHelper {
    private static final Logger logger = LoggerFactory.getLogger(SqlHelper.class);

    private SqlHelper() {
    }

    public static Object[] expandParameters(Map<String, List<Integer>> posMap, Map<String, Object> parameters) {
        int max = -1;
        for (Map.Entry<String, List<Integer>> entry : posMap.entrySet()) {
            for (Integer i : entry.getValue()) {
                max = Math.max(max, i);
            }
            if (parameters.containsKey(entry.getKey().toUpperCase())) continue;
            throw new IllegalArgumentException(String.format("Named parameter %s could not be found in parameters", entry.getKey()));
        }
        logger.trace("Max parameter: {}", (Object)max);
        if (max < 0) {
            return new Object[0];
        }
        Object[] result = new Object[max + 1];
        for (Map.Entry<String, List<Integer>> entry : posMap.entrySet()) {
            Object value = parameters.get(entry.getKey().toUpperCase());
            for (Integer i : entry.getValue()) {
                result[i.intValue()] = value;
            }
        }
        return result;
    }

    private static boolean nextEquals(CharBuffer buffer, char next) {
        if (!buffer.hasRemaining()) {
            return false;
        }
        return buffer.get(buffer.position()) == next;
    }

    private static boolean isIdentifier(char ch) {
        return Character.isLetterOrDigit(ch) || ch == '_';
    }

    public static String convertSql(String sql, Map<String, List<Integer>> posMap) {
        int length = sql.length();
        StringBuffer result = new StringBuffer(length);
        CharBuffer cb = CharBuffer.wrap(sql);
        ParseState parseState = ParseState.NORMAL;
        StringBuilder name = null;
        int currentPosition = 0;
        while (cb.hasRemaining()) {
            char c = cb.get();
            block0 : switch (parseState) {
                case NAME: {
                    if (SqlHelper.isIdentifier(c)) {
                        name.append(c);
                        break;
                    }
                    parseState = ParseState.NORMAL;
                    result.append(c);
                    SqlHelper.addToPosMap(posMap, name, currentPosition);
                    ++currentPosition;
                    break;
                }
                case QUOTE: {
                    switch (c) {
                        case '\'': {
                            if (SqlHelper.nextEquals(cb, '\'')) {
                                result.append(c);
                                cb.get();
                                break block0;
                            }
                            parseState = ParseState.NORMAL;
                            result.append(c);
                            break block0;
                        }
                    }
                    result.append(c);
                    break;
                }
                case NORMAL: {
                    switch (c) {
                        case '\'': {
                            parseState = ParseState.QUOTE;
                            result.append(c);
                            break block0;
                        }
                        case ':': {
                            parseState = ParseState.NAME;
                            result.append('?');
                            name = new StringBuilder();
                            break block0;
                        }
                    }
                    result.append(c);
                }
            }
        }
        switch (parseState) {
            case NAME: {
                logger.trace("Completing in status NAME, add remainder");
                SqlHelper.addToPosMap(posMap, name, currentPosition);
                break;
            }
        }
        return result.toString();
    }

    private static void addToPosMap(Map<String, List<Integer>> posMap, StringBuilder name, int currentPosition) {
        String key = name.toString().toUpperCase();
        List<Integer> indexes = posMap.get(key);
        if (indexes == null) {
            indexes = new LinkedList<Integer>();
            posMap.put(key, indexes);
        }
        indexes.add(currentPosition);
        logger.trace("Adding {} as parameter #{}", (Object)key, (Object)currentPosition);
    }

    private static enum ParseState {
        NORMAL,
        QUOTE,
        NAME;

    }
}

