/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.importer.aether;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.packagedrone.VersionInformation;
import org.eclipse.packagedrone.repo.importer.aether.LoggerTransferListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Helper {
    private static final Logger logger = LoggerFactory.getLogger(Helper.class);

    public static RepositorySystem newRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        locator.setErrorHandler(new DefaultServiceLocator.ErrorHandler(){

            public void serviceCreationFailed(Class<?> type, Class<?> impl, Throwable exception) {
                Logger logger = LoggerFactory.getLogger(impl);
                logger.warn("Service creation failed: " + type.getName(), exception);
            }
        });
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    public static DefaultRepositorySystemSession newRepositorySystemSession(Path tempDir, RepositorySystem system) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepo = new LocalRepository(tempDir.toFile());
        session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        session.setTransferListener((TransferListener)new LoggerTransferListener());
        session.setConfigProperty("aether.connector.userAgent", (Object)VersionInformation.USER_AGENT);
        session.setConfigProperty("aether.connector.connectTimeout", (Object)Integer.getInteger("drone.aether.connectTimeout", 30000));
        return session;
    }

    public static RemoteRepository newCentralRepository() {
        return Helper.newRemoteRepository("central", System.getProperty("drone.importer.aether.central.url", "http://central.maven.org/maven2/"));
    }

    public static RemoteRepository newRemoteRepository(String id, String url) {
        RemoteRepository.Builder builder = new RemoteRepository.Builder(id, "default", url);
        builder.setProxy(Helper.getProxy(url));
        return builder.build();
    }

    private static Proxy getProxy(String url) {
        ProxySelector ps = ProxySelector.getDefault();
        if (ps == null) {
            logger.debug("No proxy selector found");
            return null;
        }
        List<java.net.Proxy> proxies = ps.select(URI.create(url));
        for (java.net.Proxy proxy : proxies) {
            if (proxy.type() != Proxy.Type.HTTP) {
                logger.debug("Unsupported proxy type: {}", (Object)proxy.type());
                continue;
            }
            SocketAddress addr = proxy.address();
            logger.debug("Proxy address: {}", (Object)addr);
            if (!(addr instanceof InetSocketAddress)) {
                logger.debug("Unsupported proxy address type: {}", addr.getClass());
                continue;
            }
            InetSocketAddress inetAddr = (InetSocketAddress)addr;
            return new Proxy("http", inetAddr.getHostString(), inetAddr.getPort());
        }
        logger.debug("No proxy found");
        return null;
    }
}

