/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.trigger.common;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.packagedrone.repo.trigger.TriggerHandle;
import org.eclipse.packagedrone.repo.trigger.TriggerProcessor;
import org.eclipse.packagedrone.repo.trigger.TriggeredChannel;
import org.eclipse.packagedrone.repo.web.utils.ChannelServiceController;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.RequestMapping;
import org.eclipse.packagedrone.web.RequestMethod;
import org.eclipse.packagedrone.web.common.CommonController;
import org.eclipse.packagedrone.web.controller.binding.BindingResult;
import org.eclipse.packagedrone.web.controller.binding.RequestParameter;

public abstract class AbstractCommonProcessorConfigurationController<T>
extends ChannelServiceController {
    protected abstract ModelAndView handleEditUpdate(TriggeredChannel var1, TriggerHandle var2, TriggerProcessor var3, T var4, BindingResult var5);

    protected abstract ModelAndView handleCreateUpdate(TriggeredChannel var1, TriggerHandle var2, T var3, BindingResult var4);

    protected abstract ModelAndView handleEdit(TriggeredChannel var1, TriggerHandle var2, TriggerProcessor var3);

    protected abstract ModelAndView handleCreate(TriggeredChannel var1, TriggerHandle var2);

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView configure(@RequestParameter(value="channelId") String channelId, @RequestParameter(value="triggerId") String triggerId, @RequestParameter(value="processorId", required=false) String processorId) {
        return this.withChannel(channelId, TriggeredChannel.class, channel -> {
            Optional trigger = channel.getTrigger(triggerId);
            if (!trigger.isPresent()) {
                return CommonController.createNotFound((String)"trigger", (String)triggerId);
            }
            if (processorId == null || processorId.isEmpty()) {
                return this.handleCreate((TriggeredChannel)channel, (TriggerHandle)trigger.get());
            }
            Optional processor = ((TriggerHandle)trigger.get()).getProcessor(processorId);
            if (!processor.isPresent()) {
                return CommonController.createNotFound((String)"processor", (String)triggerId);
            }
            return this.handleEdit((TriggeredChannel)channel, (TriggerHandle)trigger.get(), (TriggerProcessor)processor.get());
        });
    }

    public ModelAndView processUpdate(String channelId, String triggerId, String processorId, T command, BindingResult result) {
        return this.withChannel(channelId, TriggeredChannel.class, channel -> {
            Optional trigger = channel.getTrigger(triggerId);
            if (!trigger.isPresent()) {
                return CommonController.createNotFound((String)"trigger", (String)triggerId);
            }
            if (processorId == null || processorId.isEmpty()) {
                return this.handleCreateUpdate((TriggeredChannel)channel, (TriggerHandle)trigger.get(), command, result);
            }
            Optional processor = ((TriggerHandle)trigger.get()).getProcessor(processorId);
            if (!processor.isPresent()) {
                return CommonController.createNotFound((String)"processor", (String)processorId);
            }
            return this.handleEditUpdate((TriggeredChannel)channel, (TriggerHandle)trigger.get(), (TriggerProcessor)processor.get(), command, result);
        });
    }

    protected Map<String, Object> makeModel(TriggeredChannel channel, TriggerHandle trigger, TriggerProcessor processor, boolean edit, Supplier<T> configuration) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("buttonLabel", edit ? "Update" : "Create");
        result.put("command", configuration.get());
        result.put("channelId", channel.getId().getId());
        result.put("triggerId", trigger.getId());
        if (processor != null) {
            result.put("processorId", processor.getId());
        }
        this.fillModel(result);
        return result;
    }

    protected void fillModel(Map<String, Object> model) {
    }
}

