/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.api.transfer;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.MetaKeys;
import org.eclipse.packagedrone.utils.io.CloseShieldInputStream;
import org.eclipse.packagedrone.utils.io.Streams;

public class TransferArchiveReader
implements AutoCloseable {
    private final ZipInputStream stream;

    public TransferArchiveReader(InputStream stream) {
        this.stream = new ZipInputStream(stream, StandardCharsets.UTF_8);
    }

    public void process(Handler handler) throws IOException {
        ZipEntry entry;
        Objects.requireNonNull(handler);
        HashMap<LinkedList<String>, String> paths = new HashMap<LinkedList<String>, String>();
        Map<MetaKey, String> properties = null;
        String fullName = null;
        while ((entry = this.stream.getNextEntry()) != null) {
            String name = entry.getName();
            LinkedList<String> path = this.makePath(name);
            if (path.isEmpty()) {
                throw new IllegalStateException("Invalid path entry: " + name);
            }
            if (name.endsWith("/content")) {
                if (paths.containsKey(path)) {
                    throw new IllegalStateException(String.format("Artifact %s already processed", path.stream().collect(Collectors.joining(" -> "))));
                }
                if (properties == null) {
                    throw new IllegalStateException("The 'properties.json' file must be stored before the 'content' stream");
                }
                LinkedList<String> parentPath = new LinkedList<String>(path);
                parentPath.removeLast();
                String parentId = (String)paths.get(parentPath);
                if (fullName == null) {
                    fullName = path.peekLast();
                }
                String id = handler.handleEntry(parentId, fullName, properties, (InputStream)new CloseShieldInputStream((InputStream)this.stream));
                paths.put(path, id);
                properties = null;
                fullName = null;
                continue;
            }
            if (name.endsWith("/properties.json")) {
                properties = this.loadProperties((InputStream)new CloseShieldInputStream((InputStream)this.stream));
                continue;
            }
            if (name.endsWith("/name")) {
                fullName = Streams.toString((InputStream)this.stream, (Charset)StandardCharsets.UTF_8);
                continue;
            }
            throw new IllegalStateException("Invalid path entry: " + name);
        }
    }

    private Map<MetaKey, String> loadProperties(InputStream input) throws IOException {
        return MetaKeys.readJson((Reader)new InputStreamReader((InputStream)new CloseShieldInputStream(input), StandardCharsets.UTF_8));
    }

    protected LinkedList<String> makePath(String fullName) {
        while (fullName.startsWith("/") && !fullName.isEmpty()) {
            fullName = fullName.substring(1);
        }
        String[] toks = fullName.split("/");
        LinkedList<String> result = new LinkedList<String>();
        int i = 0;
        while (i < toks.length / 2) {
            if (!toks[i * 2].equals("artifacts")) {
                throw new IllegalStateException("artifact must be contained in 'artifacts' folder");
            }
            String name = toks[i * 2 + 1];
            result.add(name);
            ++i;
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @FunctionalInterface
    public static interface Handler {
        public String handleEntry(String var1, String var2, Map<MetaKey, String> var3, InputStream var4) throws IOException;
    }

    public abstract class SimpleHandler
    implements Handler {
        private long counter;

        @Override
        public String handleEntry(String parentId, String artifactName, Map<MetaKey, String> metadata, InputStream stream) throws IOException {
            this.simpleHandleEntry(parentId, artifactName, metadata, stream);
            return Long.toString(this.counter++);
        }

        public abstract void simpleHandleEntry(String var1, String var2, Map<MetaKey, String> var3, InputStream var4);
    }
}

