/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.generator.p2;

import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.event.AddedEvent;
import org.eclipse.packagedrone.repo.event.RemovedEvent;
import org.eclipse.packagedrone.repo.generator.p2.Type;
import org.eclipse.packagedrone.repo.utils.osgi.feature.FeatureInformation;
import org.eclipse.packagedrone.repo.xml.XmlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class Helper {
    private static final Logger logger = LoggerFactory.getLogger(Helper.class);

    private Helper() {
    }

    public static boolean changeOf(Object event, Type first, Type ... rest) {
        return Helper.changeOf(event, EnumSet.of(first, rest));
    }

    public static boolean changeOf(Object event, Set<Type> types) {
        AddedEvent context;
        logger.debug("Check if we need to generate: {}", event);
        return event instanceof AddedEvent ? Helper.isChange((context = (AddedEvent)event).getMetaData(), types) : event instanceof RemovedEvent && Helper.isChange((context = (RemovedEvent)event).getMetaData(), types);
    }

    private static boolean isChange(Map<MetaKey, String> metaData, Set<Type> types) {
        for (Type type : types) {
            switch (type) {
                case BUNDLE: {
                    if (!Helper.isBundle(metaData)) break;
                    return true;
                }
                case FEATURE: {
                    if (!Helper.isFeature(metaData)) break;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean shouldRegenerateCategory(Object event) {
        logger.debug("Check if we need to generate: {}", event);
        boolean result = Helper.changeOf(event, Type.FEATURE, new Type[0]);
        logger.debug("Result: {}", (Object)result);
        return result;
    }

    public static boolean shouldRegenerateFeature(Object event) {
        logger.debug("Check if we need to generate: {}", event);
        boolean result = Helper.changeOf(event, Type.BUNDLE, new Type[0]);
        logger.debug("Result: {}", (Object)result);
        return result;
    }

    public static boolean isFeature(Map<MetaKey, String> metaData) {
        String classifier = metaData.get(new MetaKey("osgi", "classifier"));
        logger.debug("Artifact OSGi classifier: {}", (Object)classifier);
        return "eclipse.feature".equals(classifier);
    }

    public static boolean isBundle(Map<MetaKey, String> metaData) {
        String classifier = metaData.get(new MetaKey("osgi", "classifier"));
        logger.debug("Artifact OSGi classifier: {}", (Object)classifier);
        return "bundle".equals(classifier);
    }

    public static void addFeatureRequirement(Set<String> context, Element requires, ArtifactInformation a) {
        String filter;
        String id = (String)a.getMetaData().get(new MetaKey("osgi", "name"));
        if (id == null) {
            return;
        }
        String version = (String)a.getMetaData().get(new MetaKey("osgi", "version"));
        String key = String.format("%s.feature.group-%s", id, version);
        if (!context.add(key)) {
            return;
        }
        Element p = XmlHelper.addElement((Element)requires, (String)"required");
        FeatureInformation fi = FeatureInformation.fromJson((String)((String)a.getMetaData().get(FeatureInformation.META_KEY)));
        if (fi != null && (filter = fi.getQualifiers().toFilterString()) != null) {
            XmlHelper.addElement((Element)p, (String)"filter").setTextContent(filter);
        }
        p.setAttribute("namespace", "org.eclipse.equinox.p2.iu");
        p.setAttribute("name", String.valueOf(id) + ".feature.group");
        p.setAttribute("range", String.format("[%1$s,%1$s]", version));
    }

    public static void addBundleRequirement(Set<String> context, Element requires, ArtifactInformation a) {
        String id = (String)a.getMetaData().get(new MetaKey("osgi", "name"));
        if (id == null) {
            return;
        }
        String version = (String)a.getMetaData().get(new MetaKey("osgi", "version"));
        String key = String.format("%s.feature.group-%s", id, version);
        if (!context.add(key)) {
            return;
        }
        Element p = requires.getOwnerDocument().createElement("required");
        requires.appendChild(p);
        p.setAttribute("namespace", "org.eclipse.equinox.p2.iu");
        p.setAttribute("name", id);
        p.setAttribute("range", String.format("[%1$s,%1$s]", version));
    }

    public static void createFragmentFile(OutputStream out, Consumer<Element> unitsConsumer) throws IOException {
        XmlHelper xml = new XmlHelper();
        Document doc = xml.create();
        Element units = doc.createElement("units");
        doc.appendChild(units);
        unitsConsumer.accept(units);
        XmlHelper.fixSize((Element)units);
        try {
            xml.write((Node)doc, out);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static void addProperty(Element parent, String key, String value) {
        if (value == null) {
            return;
        }
        Element p = XmlHelper.addElement((Element)parent, (String)"property");
        p.setAttribute("name", key);
        p.setAttribute("value", value);
    }

    public static void createCategoryUnit(Element units, String id, String label, String description, String version, Consumer<Element> unitConsumer) {
        Element unit = XmlHelper.addElement((Element)units, (String)"unit");
        unit.setAttribute("id", id);
        unit.setAttribute("version", version);
        Element props = XmlHelper.addElement((Element)unit, (String)"properties");
        Helper.addProperty(props, "org.eclipse.equinox.p2.name", label);
        Helper.addProperty(props, "org.eclipse.equinox.p2.description", description);
        Helper.addProperty(props, "org.eclipse.equinox.p2.type.category", "true");
        XmlHelper.fixSize((Element)props);
        Element provs = XmlHelper.addElement((Element)unit, (String)"provides");
        Element p = XmlHelper.addElement((Element)provs, (String)"provided");
        p.setAttribute("namespace", "org.eclipse.equinox.p2.iu");
        p.setAttribute("name", id);
        p.setAttribute("version", version);
        XmlHelper.fixSize((Element)provs);
        unitConsumer.accept(unit);
        Element t = XmlHelper.addElement((Element)unit, (String)"touchpoint");
        t.setAttribute("id", "null");
        t.setAttribute("version", "0.0.0");
    }

    public static String makeDefaultVersion() {
        return String.format("0.0.0.0--%x", System.currentTimeMillis());
    }
}

