/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.generator.p2.xml;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.eclipse.packagedrone.repo.generator.p2.xml.CategoryDefinition;
import org.eclipse.packagedrone.repo.xml.XmlHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CategoryXmlParser {
    public static CategoryDefinition parse(Document doc) {
        Element root = doc.getDocumentElement();
        if (!"site".equals(root.getNodeName())) {
            return null;
        }
        LinkedList<CategoryDefinition.Category> cats = new LinkedList<CategoryDefinition.Category>();
        for (Element ele : XmlHelper.iterElement((Element)root, (String)"category-def")) {
            String id = ele.getAttribute("name");
            String label = ele.getAttribute("label");
            String description = XmlHelper.getText((Element)ele, (String)"description");
            if (id == null || id.isEmpty()) continue;
            cats.add(new CategoryDefinition.Category(id, label, description));
        }
        HashMap<String, Set<String>> bundles = new HashMap<String, Set<String>>();
        CategoryXmlParser.gatherElements(root, "bundle", bundles);
        HashMap<String, Set<String>> features = new HashMap<String, Set<String>>();
        CategoryXmlParser.gatherElements(root, "feature", features);
        return new CategoryDefinition(cats, bundles, features);
    }

    protected static void gatherElements(Element root, String elementName, Map<String, Set<String>> set) {
        for (Element ele : XmlHelper.iterElement((Element)root, (String)elementName)) {
            String id = ele.getAttribute("id");
            if (id.isEmpty()) continue;
            HashSet<String> eleCats = new HashSet<String>();
            for (Element childEle : XmlHelper.iterElement((Element)ele, (String)"category")) {
                String name = childEle.getAttribute("name");
                if (name.isEmpty()) continue;
                eleCats.add(name);
            }
            set.put(id, eleCats);
        }
    }
}

