/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.common.table;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.packagedrone.web.common.table.TableColumn;
import org.eclipse.packagedrone.web.common.table.TableColumnProvider;
import org.eclipse.packagedrone.web.common.table.TableDescriptor;

public interface TableExtension {
    public TableDescriptor geTableDescriptor();

    default public List<TableColumn> getColumns() {
        return this.getColumns(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    default public void extend(Object value, PrintWriter out) throws IOException {
        this.extend(value, out, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    default public List<TableColumn> getColumns(int fromPriority, int toPriority) {
        return this.streamProviders(fromPriority, toPriority).map(TableColumnProvider::getColumn).collect(Collectors.toList());
    }

    default public void extend(Object value, PrintWriter out, int fromPriority, int toPriority) throws IOException {
        for (TableColumnProvider provider : this.streamProviders(fromPriority, toPriority)::iterator) {
            if (provider.getColumn().getPriority() < fromPriority) continue;
            if (provider.getColumn().getPriority() > toPriority) break;
            provider.provideContent(this.geTableDescriptor(), value, out);
        }
    }

    default public List<TableColumnProvider> getProviders() {
        return this.getProviders(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    default public List<TableColumnProvider> getProviders(int fromPriority, int toPriority) {
        return this.streamProviders(fromPriority, toPriority).collect(Collectors.toList());
    }

    public Stream<TableColumnProvider> streamProviders(int var1, int var2);
}

