/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.dispatcher.internal;

import java.net.URL;
import java.util.Set;
import org.eclipse.packagedrone.web.dispatcher.internal.ResourceProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleResourceProvider
implements ResourceProvider {
    private static final Logger logger = LoggerFactory.getLogger(BundleResourceProvider.class);
    private final BundleContext context;

    public BundleResourceProvider(BundleContext context) {
        this.context = context;
    }

    @Override
    public URL getResource(String name) {
        long bundleId;
        if (!name.startsWith("/bundle/")) {
            return null;
        }
        String[] toks = name.split("/", 4);
        if (toks.length != 4) {
            logger.debug("Invalid format: {}", new Object[]{toks});
            return null;
        }
        if (!toks[1].equals("bundle")) {
            return null;
        }
        try {
            bundleId = Long.parseLong(toks[2]);
        }
        catch (NumberFormatException e) {
            logger.debug("Failed to parse bundle id", (Throwable)e);
            return null;
        }
        Bundle bundle = this.findBundle(bundleId);
        logger.trace("Target bundle: {}", (Object)bundle);
        if (bundle == null) {
            return null;
        }
        URL result = bundle.getEntry(toks[3]);
        logger.trace("Resource entry ({}): {}", (Object)toks[3], (Object)result);
        if (result == null) {
            return null;
        }
        logger.debug("Requesting resource: {}", (Object)result);
        return result;
    }

    @Override
    public Set<String> getPaths(String path) {
        return null;
    }

    private Bundle findBundle(long bundleId) {
        return this.context.getBundle(bundleId);
    }
}

