/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.adapter.unzip;

import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.activation.FileTypeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.adapter.unzip.MavenVersionedArtifact;
import org.eclipse.packagedrone.repo.channel.ArtifactInformation;
import org.eclipse.packagedrone.repo.channel.ChannelId;
import org.eclipse.packagedrone.repo.channel.ChannelNotFoundException;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.channel.ReadableChannel;
import org.eclipse.packagedrone.repo.channel.servlet.AbstractChannelServiceServlet;
import org.eclipse.packagedrone.repo.channel.util.DownloadHelper;
import org.eclipse.packagedrone.utils.io.IOConsumer;
import org.eclipse.scada.utils.str.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnzipServlet
extends AbstractChannelServiceServlet {
    private static final MetaKey MK_MIME_TYPE = new MetaKey("mime", "type");
    private static final MetaKey MK_MVN_EXTENSION = new MetaKey("mvn", "extension");
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(UnzipServlet.class);
    private static final MetaKey MK_GROUP_ID = new MetaKey("mvn", "groupId");
    private static final MetaKey MK_ARTIFACT_ID = new MetaKey("mvn", "artifactId");
    private static final MetaKey MK_CLASSIFIER = new MetaKey("mvn", "classifier");
    private static final MetaKey MK_VERSION = new MetaKey("mvn", "version");
    private static final MetaKey MK_SNAPSHOT_VERSION = new MetaKey("mvn", "snapshotVersion");
    private FileTypeMap fileTypeMap;

    public void init() throws ServletException {
        super.init();
        this.fileTypeMap = FileTypeMap.getDefaultFileTypeMap();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String[] toks;
        String pathString = request.getPathInfo();
        if (pathString == null) {
            this.handleNotFound("", response);
            return;
        }
        if (pathString.startsWith("/")) {
            pathString = pathString.substring(1);
        }
        if ((toks = pathString.split("/")).length < 1) {
            this.handleNotFound(request.getPathInfo(), response);
            return;
        }
        LinkedList<String> path = new LinkedList<String>(Arrays.asList(toks));
        try {
            String type;
            switch (type = path.pop()) {
                case "artifact": {
                    this.handleArtifact(request, response, path);
                    return;
                }
                case "newest": {
                    this.handleNewest(request, response, path);
                    return;
                }
                case "newestZip": {
                    this.handleNewestZip(request, response, path);
                    return;
                }
                case "newestByName": {
                    this.handleNewestByName(request, response, path);
                    return;
                }
                case "maven": {
                    this.handleMaven(request, response, path);
                    return;
                }
            }
            this.handleNotFoundError(response, String.format("Unzip target type '%s' unknown.", type));
            return;
        }
        catch (IllegalStateException e) {
            response.setStatus(404);
            response.setContentType("text/plain");
            response.getWriter().write(e.getMessage());
            return;
        }
        catch (IllegalArgumentException e) {
            response.setStatus(502);
            response.setContentType("text/plain");
            response.getWriter().write(e.getMessage());
            return;
        }
    }

    protected void handleMaven(HttpServletRequest request, HttpServletResponse response, LinkedList<String> path) throws IOException {
        if (path.isEmpty()) {
            throw new IllegalArgumentException(String.format("The 'maven' type needs an addition type (latest, prefixed, ...)", new Object[0]));
        }
        String mavenType = path.pop();
        if (path.isEmpty()) {
            throw new IllegalArgumentException(String.format("The 'maven' type needs the channel id or name after the sub-type", new Object[0]));
        }
        String channelIdOrName = path.pop();
        try {
            this.getService(request).accessRun(ChannelService.By.nameOrId((String)channelIdOrName), ReadableChannel.class, channel -> {
                IOConsumer consumer = artifact -> this.streamArtifactEntry(request, response, (ReadableChannel)channel, artifact.getArtifact(), (List<String>)path);
                switch (mavenType) {
                    case "latest": {
                        UnzipServlet.handleMavenLatest(() -> ((ReadableChannel)channel).getArtifacts(), channel.getId(), path, false, (IOConsumer<MavenVersionedArtifact>)consumer);
                        break;
                    }
                    case "latest-SNAPSHOT": {
                        UnzipServlet.handleMavenLatest(() -> ((ReadableChannel)channel).getArtifacts(), channel.getId(), path, true, (IOConsumer<MavenVersionedArtifact>)consumer);
                        break;
                    }
                    case "prefixed": {
                        UnzipServlet.handleMavenPrefixed(() -> ((ReadableChannel)channel).getArtifacts(), channel.getId(), path, (IOConsumer<MavenVersionedArtifact>)consumer);
                        break;
                    }
                    case "perfect": {
                        UnzipServlet.handleMavenPerfect(() -> ((ReadableChannel)channel).getArtifacts(), channel.getId(), path, (IOConsumer<MavenVersionedArtifact>)consumer);
                        break;
                    }
                    default: {
                        this.handleNotFoundError(response, String.format("Unknown maven sub-type: %s", mavenType));
                    }
                }
            });
        }
        catch (ChannelNotFoundException channelNotFoundException) {
            throw new IllegalStateException(String.format("Channel with ID or name '%s' not found", channelIdOrName));
        }
    }

    protected void handleNewest(HttpServletRequest request, HttpServletResponse response, LinkedList<String> path) throws IOException {
        this.handleWithFilter("newest", request, response, path, null);
    }

    protected void handleNewestZip(HttpServletRequest request, HttpServletResponse response, LinkedList<String> path) throws IOException {
        this.handleWithFilter("newestZip", request, response, path, UnzipServlet::isZip);
    }

    protected void handleWithFilter(String type, HttpServletRequest request, HttpServletResponse response, LinkedList<String> path, Predicate<ArtifactInformation> filter) throws IOException {
        UnzipServlet.requirePathPrefix(path, 1, String.format("The '%1$s' method requires at least one parameter: channel. e.g. /unzip/%1$s/<channelIdOrName>/path/to/file", type));
        String channelIdOrName = path.pop();
        ChannelService service = this.getService(request);
        try {
            service.accessRun(ChannelService.By.nameOrId((String)channelIdOrName), ReadableChannel.class, channel -> {
                List<Object> arts = new ArrayList(channel.getArtifacts());
                if (filter != null) {
                    arts = arts.stream().filter(filter).collect(Collectors.toList());
                }
                if (arts.isEmpty()) {
                    throw new IllegalStateException(String.format("Unable to find artifacts in channel '%s' (%s)", channelIdOrName, channel.getId()));
                }
                Collections.sort(arts, Comparator.comparing(ArtifactInformation::getCreationInstant));
                ArtifactInformation artifact = (ArtifactInformation)arts.get(0);
                logger.debug("Streaming artifact {} for channel {}", (Object)artifact.getId(), (Object)channelIdOrName);
                this.streamArtifactEntry(request, response, (ReadableChannel)channel, artifact, (List<String>)path);
            });
        }
        catch (ChannelNotFoundException channelNotFoundException) {
            throw new IllegalStateException(String.format("Channel with ID or name '%s' not found", channelIdOrName));
        }
    }

    protected static void processArtifacts(String sourceName, List<MavenVersionedArtifact> arts, IOConsumer<MavenVersionedArtifact> consumer) throws IOException {
        if (arts.isEmpty()) {
            throw new IllegalStateException(String.format("Unable to find artifacts in %s", sourceName));
        }
        Collections.sort(arts);
        MavenVersionedArtifact artifact = arts.get(arts.size() - 1);
        logger.debug("Streaming artifact {} for {}", (Object)artifact.getArtifact(), (Object)sourceName);
        consumer.accept((Object)artifact);
    }

    protected static void handleMavenPrefixed(Supplier<Collection<ArtifactInformation>> artifactsSupplier, ChannelId channelId, LinkedList<String> path, IOConsumer<MavenVersionedArtifact> consumer) throws IOException {
        UnzipServlet.requirePathPrefix(path, 3, "The 'maven' method requires at least one parameter: channel. e.g. /unzip/maven/prefixed/<channelIdOrName>/<group.id>/<artifact.id>/<version>/path/to/file");
        String groupId = path.pop();
        String artifactId = path.pop();
        String versionString = path.pop();
        int idx = versionString.toLowerCase().indexOf(120);
        String versionPrefix = idx > 0 ? versionString.substring(0, idx - 1) : versionString;
        boolean snapshot = versionString.endsWith("-SNAPSHOT");
        List<MavenVersionedArtifact> arts = UnzipServlet.getMavenArtifacts(channelId.getId(), artifactsSupplier, groupId, artifactId, snapshot, a -> a.toString().startsWith(versionPrefix));
        if (arts.isEmpty()) {
            throw new IllegalStateException(String.format("No artifacts found for - groupId: %s, artifactId: %s, version: %s, snapshots: %s", groupId, artifactId, versionPrefix, snapshot));
        }
        UnzipServlet.processArtifacts(String.format("maven artifact %s/%s/%s in channel %s", groupId, artifactId, versionString, channelId.getId()), arts, consumer);
    }

    protected static void handleMavenPerfect(Supplier<Collection<ArtifactInformation>> artifactsSupplier, ChannelId channelId, LinkedList<String> path, IOConsumer<MavenVersionedArtifact> consumer) throws IOException {
        UnzipServlet.requirePathPrefix(path, 3, "The 'maven' method requires at least one parameter: channel. e.g. /unzip/maven/perfect/<channelIdOrName>/<group.id>/<artifact.id>/<version>/path/to/file");
        String groupId = path.pop();
        String artifactId = path.pop();
        String versionString = path.pop();
        ComparableVersion v = new ComparableVersion(versionString);
        List<MavenVersionedArtifact> arts = UnzipServlet.getMavenArtifacts(channelId.getId(), artifactsSupplier, groupId, artifactId, true, a -> a.compareTo(v) == 0);
        if (arts.isEmpty()) {
            throw new IllegalStateException(String.format("No artifacts found for - groupId: %s, artifactId: %s, version: %s", groupId, artifactId, v));
        }
        UnzipServlet.processArtifacts(String.format("maven artifact %s/%s/%s in channel %s", groupId, artifactId, versionString, channelId.getId()), arts, consumer);
    }

    protected static void handleMavenLatest(Supplier<Collection<ArtifactInformation>> artifactsSupplier, ChannelId channelId, LinkedList<String> path, boolean snapshot, IOConsumer<MavenVersionedArtifact> consumer) throws IOException {
        UnzipServlet.requirePathPrefix(path, 2, "The 'maven' method requires at least two parameters: groupId, artifactId. e.g. /unzip/maven/latest(-SNAPSHOT)/<channelIdOrName>/<group.id>/<artifact.id>/path/to/file");
        String groupId = path.pop();
        String artifactId = path.pop();
        List<MavenVersionedArtifact> arts = UnzipServlet.getMavenArtifacts(channelId.getId(), artifactsSupplier, groupId, artifactId, snapshot, null);
        if (arts.isEmpty()) {
            throw new IllegalStateException(String.format("No artifacts found for - groupId: %s, artifactId: %s", groupId, artifactId));
        }
        UnzipServlet.processArtifacts(String.format("latest maven artifact %s/%s in channel %s", groupId, artifactId, channelId.getId()), arts, consumer);
    }

    protected static List<MavenVersionedArtifact> getMavenArtifacts(String channelId, Supplier<Collection<ArtifactInformation>> artifactsSupplier, String groupId, String artifactId, boolean snapshot, Predicate<ComparableVersion> versionFilter) {
        ArrayList<MavenVersionedArtifact> arts = new ArrayList<MavenVersionedArtifact>();
        for (ArtifactInformation ai : artifactsSupplier.get()) {
            if (!UnzipServlet.isZip(ai)) continue;
            String mvnGroupId = (String)ai.getMetaData().get(MK_GROUP_ID);
            String mvnArtifactId = (String)ai.getMetaData().get(MK_ARTIFACT_ID);
            String classifier = (String)ai.getMetaData().get(MK_CLASSIFIER);
            String mvnVersion = (String)ai.getMetaData().get(MK_VERSION);
            String mvnSnapshotVersion = (String)ai.getMetaData().get(MK_SNAPSHOT_VERSION);
            if (mvnGroupId == null || mvnArtifactId == null || mvnVersion == null || classifier != null && !classifier.isEmpty() || !mvnGroupId.equals(groupId) || !mvnArtifactId.equals(artifactId) || !snapshot && (mvnSnapshotVersion != null || mvnVersion.endsWith("-SNAPSHOT"))) continue;
            ComparableVersion v = UnzipServlet.parseVersion(mvnVersion);
            ComparableVersion sv = UnzipServlet.parseVersion(mvnSnapshotVersion);
            if (v == null) continue;
            if (versionFilter == null) {
                arts.add(new MavenVersionedArtifact(sv != null ? sv : v, channelId, ai));
                continue;
            }
            if (versionFilter.test(v)) {
                arts.add(new MavenVersionedArtifact(sv != null ? sv : v, channelId, ai));
                continue;
            }
            if (sv == null || !versionFilter.test(sv)) continue;
            arts.add(new MavenVersionedArtifact(sv, channelId, ai));
        }
        return arts;
    }

    private static ComparableVersion parseVersion(String version) {
        if (version == null) {
            return null;
        }
        try {
            return new ComparableVersion(version);
        }
        catch (Exception e) {
            logger.debug("Version not parsable: " + version, (Throwable)e);
            return null;
        }
    }

    protected static boolean isZip(ArtifactInformation artifact) {
        if (artifact.getName().toLowerCase().endsWith(".zip")) {
            return true;
        }
        String mdExtension = (String)artifact.getMetaData().get(MK_MVN_EXTENSION);
        if (mdExtension != null && mdExtension.equalsIgnoreCase("zip")) {
            return true;
        }
        String mdMime = (String)artifact.getMetaData().get(MK_MIME_TYPE);
        return mdMime != null && mdMime.equalsIgnoreCase("application/zip");
    }

    protected void handleNewestByName(HttpServletRequest request, HttpServletResponse response, LinkedList<String> path) throws IOException {
        UnzipServlet.requirePathPrefix(path, 2, "The 'newestByName' method requires at least two parameters: channel and name. e.g. /unzip/newestByName/<channelIdOrName>/<artifactName>/path/to/file");
        String channelIdOrName = path.pop();
        String name = path.pop();
        try {
            this.getService(request).accessRun(ChannelService.By.nameOrId((String)channelIdOrName), ReadableChannel.class, channel -> {
                List arts = channel.getArtifacts().stream().filter(ai -> ai.getName().equals(name)).collect(Collectors.toList());
                if (arts.isEmpty()) {
                    throw new IllegalStateException(String.format("Unable to find artifact with name '%s' in channel '%s' (%s)", name, channelIdOrName, channel.getId()));
                }
                Collections.sort(arts, Comparator.comparing(ArtifactInformation::getCreationInstant));
                ArtifactInformation artifact = (ArtifactInformation)arts.get(0);
                logger.debug("Streaming artifact {} for name {} in channel {}", new Object[]{artifact.getId(), name, channelIdOrName});
                this.streamArtifactEntry(request, response, (ReadableChannel)channel, artifact, (List<String>)path);
            });
        }
        catch (ChannelNotFoundException channelNotFoundException) {
            throw new IllegalStateException(String.format("Channel with ID or name '%s' not found", channelIdOrName));
        }
    }

    private static void requirePathPrefix(LinkedList<String> path, int pathPrefixCount, String message) {
        if (path.size() < pathPrefixCount) {
            throw new IllegalArgumentException(message);
        }
    }

    protected void handleArtifact(HttpServletRequest request, HttpServletResponse response, LinkedList<String> path) throws IOException {
        UnzipServlet.requirePathPrefix(path, 2, "The 'artifact' method requires at least two parameters: channelId and artifactId. e.g. /unzip/artifact/<channelIdOrName>/<artifactId>/path/to/file");
        String channelIdOrName = path.pop();
        try {
            this.getService(request).accessRun(ChannelService.By.nameOrId((String)channelIdOrName), ReadableChannel.class, channel -> {
                String artifactId = (String)path.pop();
                Optional artifact = channel.getArtifact(artifactId);
                if (!artifact.isPresent()) {
                    this.handleNotFoundError(response, String.format("Artifact '%s' could not be found", artifactId));
                    return;
                }
                this.streamArtifactEntry(request, response, (ReadableChannel)channel, (ArtifactInformation)artifact.get(), (List<String>)path);
            });
        }
        catch (ChannelNotFoundException channelNotFoundException) {
            throw new IllegalStateException(String.format("Channel with ID or name '%s' not found", channelIdOrName));
        }
    }

    protected void streamArtifactEntry(HttpServletRequest request, HttpServletResponse response, ReadableChannel channel, ArtifactInformation artifact, List<String> path) throws IOException {
        String localPath = StringHelper.join(path, (String)"/");
        if (localPath.isEmpty()) {
            DownloadHelper.streamArtifact((HttpServletResponse)response, (ArtifactInformation)artifact, Optional.empty(), (boolean)true, (ReadableChannel)channel, null);
            return;
        }
        if (!channel.getContext().stream(artifact.getId(), stream -> {
            Throwable throwable = null;
            Object var6_7 = null;
            try (ZipInputStream zis = new ZipInputStream((InputStream)stream);){
                ZipEntry entry;
                while ((entry = zis.getNextEntry()) != null) {
                    if (!entry.getName().equals(localPath)) continue;
                    String type = this.fileTypeMap.getContentType(entry.getName());
                    response.setContentType(type);
                    long size = entry.getSize();
                    if (size > 0L) {
                        response.setContentLengthLong(entry.getSize());
                    }
                    response.setDateHeader("Last-Modified", artifact.getCreationTimestamp().getTime());
                    ByteStreams.copy((InputStream)zis, (OutputStream)response.getOutputStream());
                    break;
                }
                if (entry == null || !entry.getName().equals(localPath)) {
                    this.handleNotFoundError(response, String.format("File entry '%s' could not be found in artifact '%s'", localPath, artifact.getId()));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        })) {
            this.handleNotFoundError(response, String.format("Artifact %s could not be found", artifact.getId()));
        }
    }

    protected void handleNotFound(String path, HttpServletResponse response) throws IOException {
        this.handleNotFoundError(response, String.format("Resource '%s' cound not be found", path));
    }

    protected void handleNotFoundError(HttpServletResponse response, String message) throws IOException {
        response.setStatus(404);
        response.setContentType("text/plain");
        response.getWriter().write(message);
    }
}

