/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.validation;

import javax.validation.Configuration;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.ValidationProviderResolver;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.bootstrap.GenericBootstrap;
import org.eclipse.packagedrone.utils.validation.OsgiMessageInterpolator;
import org.eclipse.packagedrone.utils.validation.OsgiValidationProviderTracker;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class ValidationBundle
implements BundleActivator {
    private static OsgiMessageInterpolator messageInterpolator;
    private static OsgiValidationProviderTracker tracker;
    private static Validator validator;
    private static int lastTrackingCount;

    public void start(BundleContext context) throws Exception {
        messageInterpolator = new OsgiMessageInterpolator(context);
        tracker = new OsgiValidationProviderTracker();
        tracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        tracker.close();
        messageInterpolator.dispose();
        messageInterpolator = null;
    }

    public static OsgiMessageInterpolator getMessageInterpolator() {
        return messageInterpolator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Validator getValidator() {
        Class<ValidationBundle> clazz = ValidationBundle.class;
        synchronized (ValidationBundle.class) {
            if (lastTrackingCount != tracker.getTrackingCount()) {
                lastTrackingCount = tracker.getTrackingCount();
                validator = null;
            }
            if (validator == null) {
                validator = ValidationBundle.buildValidator();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return validator;
        }
    }

    private static Validator buildValidator() {
        GenericBootstrap bootstrap = Validation.byDefaultProvider();
        bootstrap.providerResolver((ValidationProviderResolver)tracker);
        Configuration cfg = bootstrap.configure();
        OsgiMessageInterpolator mi = ValidationBundle.getMessageInterpolator();
        mi.setFallback(cfg.getDefaultMessageInterpolator());
        cfg.messageInterpolator((MessageInterpolator)mi);
        ValidatorFactory factory = cfg.buildValidatorFactory();
        return factory.getValidator();
    }
}

