/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz.simple;

import org.tukaani.xz.simple.SimpleFilter;

public final class IA64
implements SimpleFilter {
    private static final int[] BRANCH_TABLE;
    private final boolean isEncoder;
    private int pos;

    static {
        int[] nArray = new int[32];
        nArray[16] = 4;
        nArray[17] = 4;
        nArray[18] = 6;
        nArray[19] = 6;
        nArray[22] = 7;
        nArray[23] = 7;
        nArray[24] = 4;
        nArray[25] = 4;
        nArray[28] = 4;
        nArray[29] = 4;
        BRANCH_TABLE = nArray;
    }

    public IA64(boolean isEncoder, int startPos) {
        this.isEncoder = isEncoder;
        this.pos = startPos;
    }

    @Override
    public int code(byte[] buf, int off, int len) {
        int end = off + len - 16;
        int i = off;
        while (i <= end) {
            int instrTemplate = buf[i] & 0x1F;
            int mask = BRANCH_TABLE[instrTemplate];
            int slot = 0;
            int bitPos = 5;
            while (slot < 3) {
                if ((mask >>> slot & 1) != 0) {
                    int bytePos = bitPos >>> 3;
                    int bitRes = bitPos & 7;
                    long instr = 0L;
                    int j = 0;
                    while (j < 6) {
                        instr |= ((long)buf[i + bytePos + j] & 0xFFL) << 8 * j;
                        ++j;
                    }
                    long instrNorm = instr >>> bitRes;
                    if ((instrNorm >>> 37 & 0xFL) == 5L && (instrNorm >>> 9 & 7L) == 0L) {
                        int src = (int)(instrNorm >>> 13 & 0xFFFFFL);
                        src |= ((int)(instrNorm >>> 36) & 1) << 20;
                        int dest = this.isEncoder ? src + (this.pos + i - off) : (src <<= 4) - (this.pos + i - off);
                        instrNorm &= 0xFFFFFFEE00001FFFL;
                        instrNorm |= ((long)(dest >>>= 4) & 0xFFFFFL) << 13;
                        instr &= (long)((1 << bitRes) - 1);
                        instr |= (instrNorm |= ((long)dest & 0x100000L) << 16) << bitRes;
                        int j2 = 0;
                        while (j2 < 6) {
                            buf[i + bytePos + j2] = (byte)(instr >>> 8 * j2);
                            ++j2;
                        }
                    }
                }
                ++slot;
                bitPos += 41;
            }
            i += 16;
        }
        this.pos += (i -= off);
        return i;
    }
}

