/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.access;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.passage.lic.api.LicensingConfiguration;
import org.eclipse.passage.lic.api.access.FeaturePermission;
import org.eclipse.passage.lic.api.access.PermissionExaminer;
import org.eclipse.passage.lic.api.conditions.LicensingCondition;
import org.eclipse.passage.lic.api.requirements.LicensingRequirement;
import org.eclipse.passage.lic.api.restrictions.RestrictionVerdict;
import org.eclipse.passage.lic.base.LicensingVersions;
import org.eclipse.passage.lic.base.restrictions.RestrictionVerdicts;

public abstract class BasePermissionExaminer
implements PermissionExaminer {
    public Iterable<RestrictionVerdict> examine(LicensingConfiguration configuration, Iterable<LicensingRequirement> requirements, Iterable<FeaturePermission> permissions) {
        HashMap<String, List> required = new HashMap<String, List>();
        for (LicensingRequirement requirement : requirements) {
            String featureId = requirement.getFeatureIdentifier();
            List list = required.computeIfAbsent(featureId, key -> new ArrayList());
            list.add(requirement);
        }
        ArrayList<RestrictionVerdict> verdicts = new ArrayList<RestrictionVerdict>();
        Set features = required.keySet();
        ArrayList<LicensingCondition> leased = new ArrayList<LicensingCondition>();
        for (String featureId : features) {
            List requirementList = (List)required.get(featureId);
            List<RestrictionVerdict> examined = this.examineFeatures(configuration, requirementList, permissions, leased);
            verdicts.addAll(examined);
        }
        if (!leased.isEmpty()) {
            this.postEvent("org/eclipse/passage/lic/api/ConditionEvents/conditionsLeased", Collections.unmodifiableList(leased));
        }
        return Collections.unmodifiableList(verdicts);
    }

    protected List<RestrictionVerdict> examineFeatures(LicensingConfiguration configuration, List<LicensingRequirement> requirements, Iterable<FeaturePermission> permissions, List<LicensingCondition> conditions) {
        ArrayList<LicensingRequirement> unsatisfied = new ArrayList<LicensingRequirement>(requirements);
        for (FeaturePermission permission : permissions) {
            ArrayList<LicensingRequirement> covered = new ArrayList<LicensingRequirement>();
            for (LicensingRequirement requirement : unsatisfied) {
                if (!this.isCovered(requirement, permission)) continue;
                covered.add(requirement);
                conditions.add(permission.getLicensingCondition());
            }
            unsatisfied.removeAll(covered);
        }
        ArrayList<RestrictionVerdict> verdicts = new ArrayList<RestrictionVerdict>();
        for (LicensingRequirement requirement : unsatisfied) {
            verdicts.add(this.createVerdict(configuration, requirement, 401));
        }
        return Collections.unmodifiableList(verdicts);
    }

    protected RestrictionVerdict createVerdict(LicensingConfiguration configuration, LicensingRequirement requirement, int code) {
        return RestrictionVerdicts.create(configuration, requirement, code);
    }

    protected boolean isCovered(LicensingRequirement requirement, FeaturePermission permission) {
        LicensingCondition condition = permission.getLicensingCondition();
        if (condition == null) {
            return false;
        }
        if (!Objects.equals(requirement.getFeatureIdentifier(), condition.getFeatureIdentifier())) {
            return false;
        }
        return LicensingVersions.isMatch(requirement.getFeatureVersion(), condition.getMatchVersion(), condition.getMatchRule());
    }

    protected abstract void postEvent(String var1, Object var2);
}

